# -*- coding: utf-8 -*-

from __future__ import division

# если импортировать сам класс, он станет отдельным таском в SB
from sandbox.projects.infratools.vteam.charts import base
from sandbox.projects.infratools.vteam.libs.scales import get_keys, get_start_point
import sandbox.projects.infratools.vteam.libs.issues as sti
import sandbox.projects.infratools.vteam.libs.statface as stat


class VteamKgbChart(base.VteamChart):
    """VTeam - KGB"""

    measures = {
        'team_weight': stat.Type.NUMBER,
        'team_issues': stat.Type.STRING,
        'team_priorities': stat.Type.STRING,
        'other_weight': stat.Type.NUMBER,
        'other_issues': stat.Type.STRING,
        'other_priorities': stat.Type.STRING
    }

    def calculate(self, issues):
        points = []
        details = [self.details_point(issue) for issue in issues]

        start_date = get_start_point(self.Parameters.scale, sti.dates(issues, 'createdAt'))
        dates = get_keys(self.Parameters.scale, start=start_date)

        for i in range(1, len(dates)):
            current_date = dates[i - 1]
            next_date = dates[i]

            found_by_team = {}
            found_by_others = {}

            for issue in issues:
                if sti.value(issue, 'createdAt') >= next_date:
                    continue

                is_found_by_team = int(u'Команда' in (sti.value(issue, 'bugSource') or []))
                priority = sti.value(issue, 'priority')
                key = sti.value(issue, 'key')

                if is_found_by_team:
                    found_by_team[key] = priority
                else:
                    found_by_others[key] = priority

            points.append(self.point(
                current_date,
                team_weight=sum(sti.weight_by_priority(priority) or 0 for priority in found_by_team.values()) / i,
                team_issues=','.join(found_by_team.keys()),
                team_priorities=','.join(found_by_team.values()),
                other_weight=sum(sti.weight_by_priority(priority) or 0 for priority in found_by_others.values()) / i,
                other_issues=','.join(found_by_others.keys()),
                other_priorities=','.join(found_by_others.values())
            ))

        return points, details
