# -*- coding: utf-8 -*-

import json

from sandbox.projects.infratools.vteam.libs.series.series import SlaSeries, IntervalSeries, IntervalSeriesMulti


def from_json(string):
    """Парсит JSON с набором данных серий графика, возвращает список экземпляров серий.

    :param string:

    :rtype: list
    """
    parsed = json.loads(string)
    if not isinstance(parsed, list):
        parsed = [parsed]

    return [from_type(item) for item in parsed]


def from_type(data):
    """Возвращает экземпляр нужного типа серии, в зависимости от поля `type`.

    :param dict data: данные серии

    :rtype: Series

    :raises NotImplementedError: в случае некорректного типа
    """
    try:
        return {
            'sla': SlaSeries,
            'interval': IntervalSeries,
            'interval_multi': IntervalSeriesMulti
        }[data.get('type')](data)
    except KeyError as key:
        raise NotImplementedError('Series type "%s" is not implemented' % key)
