# -*- coding: utf-8 -*-
import os
from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.common.build.parameters import get_arcadia_params
from sandbox.projects.inventori.artifacts import INVENTORI_ETL_ARTIFACTS
from sandbox.projects.inventori.common.resources import InventoriDatabase


class BuildInventoriEtlBinaries(YaMakeTask):
    type = 'BUILD_INVENTORI_ETL_BINARIES'
    descr = 'Build inventori etl binaries'

    # Исключает из параметров всё то, что не следует заполнять вручную.
    input_parameters = get_arcadia_params()

    def get_arts(self):
        return [
            {
                'path': os.path.join(path, name),  # где будет лежать артефакт после сборки
                'dest': '',  # каталог, куда поместить артефакт относительно корня архива-ресурса
            }
            for name, path in INVENTORI_ETL_ARTIFACTS.items()
        ]

    def get_arts_source(self):
        return []

    def get_targets(self):
        return INVENTORI_ETL_ARTIFACTS.values()

    def get_resources(self):
        return {
            'project': {
                'description': 'Inventori etl binaries',
                'resource_type': InventoriDatabase.name,
            }
        }
