# -*- coding: utf-8 -*-
import os

from sandbox import sdk2

import sandbox.projects.common.build.parameters as build_params
import sandbox.projects.common.constants as consts
from sandbox.projects.common import binary_task
from sandbox.projects.common.ya_deploy import release_integration
from sandbox.projects.inventori.InventoriArcYaMake2 import InventoriArcYaMake2
from sandbox.projects.inventori.artifacts import INVENTORI_SERVER_ARTIFACTS, INVENTORI_PERFORMANCE_SERVER_ARTIFACTS
from sandbox.projects.inventori.common.resources import InventoriServerBinaries, InventoriPerformanceServerBinaries


class BuildInventoriServerBinaries(release_integration.ReleaseToYaDeployTask2, InventoriArcYaMake2):
    descr = 'Build server jar with all dependencies.'

    class Parameters(InventoriArcYaMake2.Parameters):
        ext_params = binary_task.binary_release_parameters(custom=True)

        build_system = build_params.BuildSystem(default_value=consts.YA_MAKE_FORCE_BUILD_SYSTEM)
        definition_flags = build_params.DefinitionFlags(default_value="-DJDK_VERSION=11")
        targets = sdk2.parameters.String("Targets (semicolon separated)", required=False)

        with sdk2.parameters.RadioGroup("Server type") as server_type:
            server_type.values['media'] = server_type.Value('media', default=True)
            server_type.values['performance'] = server_type.Value('performance')

    def get_server_type(self):
        if self.Parameters.server_type == 'media':
            return INVENTORI_SERVER_ARTIFACTS
        if self.Parameters.server_type == 'performance':
            return INVENTORI_PERFORMANCE_SERVER_ARTIFACTS
        raise ValueError('Unknown server type')

    def get_arts(self):
        return [
            {
                'path': os.path.join(path, name),  # где будет лежать артефакт после сборки
                'dest': '',  # каталог, куда поместить артефакт относительно корня архива-ресурса
            } for name, path in self.get_server_type().items()
        ]

    def get_arts_source(self):
        return []

    def get_targets(self):
        # return INVENTORI_SERVER_ARTIFACTS.values()
        return self.get_server_type().values()

    def get_resources(self):
        return {
            'project': {
                'description': 'Inventori server binaries.',
                'resource_type': InventoriServerBinaries.name,
            }
        } if self.Parameters.server_type == 'media' else {
            'project': {
                'description': 'Inventori performance server binaries.',
                'resource_type': InventoriPerformanceServerBinaries.name,
            }
        }

    @property
    def release_template(self):
        subject = 'Automatic release of ' + self.Parameters.description
        default_emails = ['inventori-monitoring@yandex-team.ru']
        release_types = ['unstable', 'testing', 'stable']

        return sdk2.task.ReleaseTemplate(default_emails, subject, "", release_types)

    def get_yp_oauth_token(self):
        return sdk2.Vault.data("INVENTORI_YP_TOKEN")
