# -*- coding: utf-8 -*-
import logging
import re

from sandbox import sdk2

import sandbox.projects.common.build.parameters as build_parameters
from sandbox.projects.common.build.YaMake2 import YaMake2
from sandbox.projects.common.vcs import arc
from sandbox.projects.common.vcs import util as vcs_util


class InventoriArcYaMake2(YaMake2):

    class Parameters(YaMake2.Parameters):
        ya_make_project_params = None  # remove this params as we build specific target(s)
        checkout_arcadia_from_url = sdk2.parameters.ArcadiaUrl('Arcadia URL', required=True,
                                                               default_value='arcadia-arc:/#trunk')
        arc_secret = build_parameters.ArcSecret(default='sec-01eb89vakhn60j7ynwmr16a9ne#arc_token')

    def pre_build(self, source_dir):
        super(InventoriArcYaMake2, self).pre_build(source_dir)
        try:
            arcadia_url = self.Parameters.checkout_arcadia_from_url.strip()
            _, commit_id, req_type = vcs_util.extract_path_details(arcadia_url)
            if req_type == vcs_util.ARC_VCS:
                commit_info = []

                commit_hash = arc.Arc().rev_parse(source_dir, commit_id)
                if commit_hash is None:
                    logging.error('Could not get commit hash')
                    return
                self.Context.arc_commit_hash = commit_hash
                commit_info.append('Commit hash: {}'.format(commit_hash))

                tags = arc.Arc().describe(source_dir, commits=[commit_hash], svn=True)
                if tags and len(tags) > 0:
                    self.Context.arc_commit_svn_rev = tags[0]
                    commit_info.append('Svn revision: {}'.format(tags[0]))

                try:
                    pr_status = arc.Arc().pr_status(source_dir).decode('utf-8')
                except arc.ArcCommandFailed:
                    logging.exception('Failed to get pr status')
                else:
                    logging.info('pr_status:\n%s', pr_status)
                    m = re.search(r'https://a.yandex-team\.ru/review/(\d+)', pr_status)
                    if m:
                        self.Context.arc_commit_pr_review = m.group(1)
                        commit_info.append('Review (PR): <a href="{0}">{0}</a>'.format(m.group(0)))

                if len(commit_info) > 1:
                    self.set_info('Commit info: {}'.format('\n    '.join([''] + commit_info)), do_escape=False)
                elif commit_info:
                    self.set_info(commit_info[0], do_escape=False)
        except Exception:
            logging.exception('Getting arc commit hash failed')
