import copy
import logging

import sandbox.common.types.notification as ctn
from sandbox.common.types import resource as ctr

from sandbox.projects.inventori.common.binary_task import LastBinaryTaskRelease
from sandbox.projects.inventori.common.utils import cached_property
from sandbox.projects.rope.RunTaskTemplate import BinaryResourceExecutor
from sandbox.projects.rope.RunTaskTemplate import RunTaskTemplate
from sandbox.projects.rope.RunTaskTemplate import TaskParamsTemplate
from sandbox.projects.rope.RunTaskTemplate import get_resource_task_name  # noqa
from sandbox.projects.rope.RunTaskTemplate import get_run_params  # noqa

SECONDS_WAITING_FOR_YQL_LINK_FROM_BINARY = 7  # second

MESSAGE_FOR_SHARED_LINK = 'YQL shared link on cluster'


class InventoryTaskParamsTemplate(TaskParamsTemplate):
    logger = logging.getLogger('inventori task runner')

    @property
    def current_tags(self):
        tags = []
        for tag in self.Parameters.tags:
            tags.append(str(tag))
        return tags

    def append_tag(self, tag):
        tag_formatted = tag.upper()
        if tag_formatted not in self.current_tags:
            self.Parameters.tags.append(tag_formatted)

    @cached_property
    def environment_type(self):
        if hasattr(self.task_params_class, 'environment_type'):
            return self.task_params_class.environment_type.load_from_params(self.Parameters)

    def on_enqueue(self):
        super(InventoryTaskParamsTemplate, self).on_enqueue()
        self.append_tag(self.environment_type)


class InventoryRunTaskTemplate(RunTaskTemplate):
    logger = logging.getLogger('inventori task runner')

    @cached_property
    def environment_type(self):
        if hasattr(self.task_params_class, 'environment_type'):
            return self.task_params_class.environment_type.load_from_params(
                self.Parameters, prefix=self.task_initializer.task_prefix)

    def process_task_error(self, ex):
        """
        Process subprocess exception
        :param ex: subprocess.CalledProcessError
        """
        super(InventoryRunTaskTemplate, self).process_task_error(ex)
        self.server.notification(
            subject='SOMETHING WRONG for {task_name} task #{task_id}'.format(
                task_name=self.task_name, task_id=self.id),
            recipients=['inventori-monitoring@yandex-team.ru'],
            transport=ctn.Transport.EMAIL,
            type=ctn.Type.HTML,
            charset=ctn.Charset.UTF,
            task_id=self.id,
            view=ctn.View.EXECUTION_REPORT,
        )

    def on_enqueue(self):
        super(InventoryRunTaskTemplate, self).on_enqueue()
        self.append_tag(self.environment_type)


class InventoriRunTaskTemplateVersioned(InventoryRunTaskTemplate, LastBinaryTaskRelease):

    def binary_executor_query_iter(self):
        query = {
            'attrs': {
                'task_type': self.type.name,   # noqa
                'released': self.Parameters.binary_executor_release_type,   # noqa
            },
            'state': [ctr.State.READY],
        }
        yield query
        if (
            self.Parameters._task_type  # noqa
            and not isinstance(self.task_initializer, BinaryResourceExecutor)
        ):
            query = copy.deepcopy(query)
            query['attrs']['task_type'] = ':'.join([self.type.name, self.Parameters._task_type])  # noqa
            yield query

    def on_save(self):
        LastBinaryTaskRelease.on_save(self)  # setup_requirement
        super(InventoriRunTaskTemplateVersioned, self).on_save()

    def on_execute(self):
        LastBinaryTaskRelease.on_execute(self)  # validate_resource_executor
        super(InventoriRunTaskTemplateVersioned, self).on_execute()
