PROD = "prod"
TEST = "test"
DEV = "dev"
CUSTOM = "custom"

PROD_BACKTESTING = "prod backtesting"
TEST_BACKTESTING = "test backtesting"
DEV_BACKTESTING = "dev backtesting"
CUSTOM_BACKTESTING = "custom backtesting"

#
#   ETL
#

PLATFORM_YT_DATA_FOLDER = "yt-data"
PLATFORM_YT_ARCHIVE_NAME = '%s.%s' % (PLATFORM_YT_DATA_FOLDER, 'tar.gz')

JSON_FORMAT = 'json'
JSON_LINE_FORMAT = 'jsonl'
CSV_FORMAT = 'csv'

CSV_FILED_SEPARATOR = ";"

# Keys could be either prefix with prefix_name_* format or full table name
# TODO: rename consts from ..._TABLES_REFIX_TO_COLUMNS -> ..._TABLES_TO_COLUMNS

OTHER_TABLES_PREFIX_TO_COLUMNS = {
    "parameters": "sample_factor,min_reach,history_start,history_end,start_forecast_date",
    "traffic_*": "cryptaid,pageid,blockid,domain,device_type,os_type,index,cpms,impressions_position_0,impressions_position_other,impressions_capacity,unknown_brand_safety_categories,dsp_log_keyword_975_top_ancestor_undetermined,top_ancestor,region_id,genres_and_categories,segmentIds,direct_impressions_for_duration_lte5,direct_true_views_for_duration_lte5,direct_impressions_for_duration_gt5_lte10,direct_true_views_for_duration_gt5_lte10,direct_impressions_for_duration_gt10_lte15,direct_true_views_for_duration_gt10_lte15,direct_impressions_for_duration_gt15_lte20,direct_true_views_for_duration_gt15_lte20,direct_impressions_for_duration_gt20_lte25,direct_true_views_for_duration_gt20_lte25,direct_impressions_for_duration_gt25_lte30,direct_true_views_for_duration_gt25_lte30,direct_impressions_for_duration_gt30,direct_true_views_for_duration_gt30,imp_to_tv_coeff",
    "segments_list": "segmentId",
    "daily_history_campaigns_performance": "cid,spent_budget,impressions,stat_date,true_views",
    "pi_data": "pageid,blockid,possible_sizes,block_width,block_height,price_threshold,partner_share,adtype_price_threshold,options_allow_multiple_dsp_ads,design_name,design_names_from_json,target_tags,target_tags_from_page,order_tags,order_tags_from_page,is_rewarded_block,block_settings,product_type,is_business_unit,is_yandex_page,is_mobile_app,domain_list,ad_types,ad_type_audio,ad_type_media,ad_type_media_performance,ad_type_text,ad_type_video,ad_type_video_motion,ad_type_video_non_skippable,ad_type_video_performance,is_ssp",
    "video_timeseries": "date,inventory_type,traffic_type,page_type,predicted_0_position_inventory_capacity",
    "banner_timeseries": "date,traffic_type,page_type,predicted_inventory_capacity",

    "main_page_and_ntp_traffic_*": "cryptaid,pageid,blockid,region_id,index,impressions,white_inventory,segmentIds,os_type,device_type",
    "main_page_and_ntp_timeseries": "platform,regionId,date,predicted_visits",
    "main_page_and_ntp_pages_dict": "pageid,possible_sizes,target_tags",
    "main_page_and_ntp_bookings": "cid,campaign",
    "segments_dict": "bb_keyword,bb_keyword_value,name",
    "social_campaigns_current_month": "cid",
    "known_segments": "segmentId",
    "autoru_timeseries": "date,traffic_type,predicted_watchs",
    "realty_timeseries": "date,platform,predicted_watchs",
    "realty_parameters": "sample_factor,history_start,history_end",
    "realty_traffic_*": "index,cryptaid,pageid,blockid,keyword_638_aka_puid18,detaileddevicetype,devicetype,impressions,white_inventory,regionid",
    "autoru_parameters": "sample_factor,history_start,history_end",
    "autoru_traffic_*": "index,cryptaid,pageid,blockid,keyword_630_aka_puid10,keyword_622_aka_puid2,detaileddevicetype,devicetype,impressions,white_inventory,regionid",
    "autoru_target_tags": "target_tag",
    "realty_target_tags": "target_tag",
}

BACKSTAGING_TABLES_PREFIX_TO_COLUMNS = {
    "campaigns": "cid,campaign",
    "campaigns_metainfo": "cid,start_time,finish_time",
    "backtesting_stat": "cid,fact_impressions,fact_budget,first_modification_date",
    "backtesting_metainfo": "backtesting_daily_result_dir",
    "backtesting_parameters": "backtesting_start,backtesting_end"
}


#   Tables with its schemas for ETL

JSON_FORMAT_TABLES_PREFIX_TO_COLUMNS = OTHER_TABLES_PREFIX_TO_COLUMNS

# We removed all indexes here - https://st.yandex-team.ru/INVENTORI-4069#60d999d11a26ec16f928a974
CSV_FORMAT_TABLES_PREFIX_TO_COLUMNS = {}


#   Tables with its schemas for backtesting ETL

JSON_FORMAT_BACKTESTING_TABLES_PREFIX_TO_COLUMNS = dict(
    tuple(BACKSTAGING_TABLES_PREFIX_TO_COLUMNS.items()) + tuple(JSON_FORMAT_TABLES_PREFIX_TO_COLUMNS.items())
)

CSV_FORMAT_BACKTESTING_TABLES_PREFIX_TO_COLUMNS = CSV_FORMAT_TABLES_PREFIX_TO_COLUMNS
