import sandbox.sdk2 as sdk2

from . import config
from . import consts


class EnvironmentParameters(sdk2.Task.Parameters):
    with sdk2.parameters.RadioGroup("Environment type") as environment_type:
        environment_type.values[consts.PROD] = environment_type.Value(consts.PROD)
        environment_type.values[consts.TEST] = environment_type.Value(consts.TEST)
        environment_type.values[consts.DEV] = environment_type.Value(consts.DEV, default=True)
        environment_type.values[consts.CUSTOM] = environment_type.Value(consts.CUSTOM)

    with environment_type.value[consts.CUSTOM]:
        yt_project_dir = sdk2.parameters.String("Yt project directory", required=True)
        platform = sdk2.parameters.List("Platform",
                                        sdk2.parameters.String,
                                        default=[],
                                        required=True
                                        )

    with sdk2.parameters.RadioGroup("Backtesting Environment") as backtesting_environment_type:
        backtesting_environment_type.values[consts.PROD_BACKTESTING] = backtesting_environment_type.Value(
            consts.PROD_BACKTESTING)
        backtesting_environment_type.values[consts.TEST_BACKTESTING] = backtesting_environment_type.Value(
            consts.TEST_BACKTESTING)
        backtesting_environment_type.values[consts.DEV_BACKTESTING] = backtesting_environment_type.Value(
            consts.DEV_BACKTESTING, default=True)
        backtesting_environment_type.values[consts.CUSTOM_BACKTESTING] = backtesting_environment_type.Value(
            consts.CUSTOM_BACKTESTING)

    with backtesting_environment_type.value[consts.CUSTOM_BACKTESTING]:
        backtesting_yt_project_dir = sdk2.parameters.String("Backtesting YT project directory", required=True)
        backtesting_platform = sdk2.parameters.List("Backtesting platform",
                                                    sdk2.parameters.String,
                                                    default=[],
                                                    required=True
                                                    )


def init_yt_params(self):
    environment_params = {
        consts.PROD: {
            'yt_project_dir': config.PROD_YT_PROJECT_DIRECTORY
        },
        consts.TEST: {
            'yt_project_dir': config.TEST_YT_PROJECT_DIRECTORY
        },
        consts.DEV: {
            'yt_project_dir': config.DEV_YT_PROJECT_DIRECTORY
        },
        consts.CUSTOM: {
            'yt_project_dir': self.Parameters.yt_project_dir
        }
    }

    env_params = environment_params[self.Parameters.environment_type]
    self.yt_project_dir = env_params['yt_project_dir']


def init_yt_backtasting_params(self):
    backtesting_environment_params = {
        consts.PROD_BACKTESTING: {
            'backtesting_yt_project_dir': config.PROD_YT_PROJECT_DIRECTORY
        },
        consts.TEST_BACKTESTING: {
            'backtesting_yt_project_dir': config.TEST_YT_PROJECT_DIRECTORY
        },
        consts.DEV_BACKTESTING: {
            'backtesting_yt_project_dir': config.DEV_YT_PROJECT_DIRECTORY
        },
        consts.CUSTOM_BACKTESTING: {
            'backtesting_yt_project_dir': self.Parameters.yt_project_dir
        },
    }

    env_params = backtesting_environment_params[self.Parameters.environment_type]
    self.yt_project_dir = env_params['backtesting_yt_project_dir']
