# -*- coding: utf-8 -*-
import logging
import time
from sandbox import sdk2

logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__name__)


def get_yql_env_from_parameters(parameters):
    """
    Создаем словарь с перенными окружения для запуска программ, использующих YQL

    YQL_PROXY берётся из parameters.yql_proxy. YQL_TOKEN берётся из Sandbox vault, если parameters.yql_token_vault_name
    не пуст (parameters.yql_token_vault_user может быть пустым).

    :param parameters: sdk2.Task.Parameters с установленными полями yql_proxy, yql_token_vault_name
    :return: словарь с переменными окружения
    :rtype dict
    """

    yql_proxy = parameters.yql_proxy
    yql_token_vault_user = parameters.yql_token_vault_user
    yql_token_vault_name = parameters.yql_token_vault_name

    env = {
        'YQL_PROXY': yql_proxy
    }
    if yql_token_vault_name:
        if yql_token_vault_user:
            token = sdk2.Vault.data(yql_token_vault_user, yql_token_vault_name)
        else:
            token = sdk2.Vault.data(yql_token_vault_name)
        env['YQL_TOKEN'] = token

    return env


def run_yql_command(yql, command_name, query):
    logger.info("LOADING PARAMETERS TO RESULT TABLE")

    logger.info('%s: %s' % (command_name, 'in process'))

    start_time = time.time()

    logger.info(query)

    yql_command = yql.query(query, syntax_version=1)
    yql_command.run()

    result = yql_command.get_results()

    duration = time.time() - start_time

    if result.is_success:
        logger.info('%s: %s = %s %s' % (command_name, 'finished, duration', duration, 'seconds'))
    else:
        logger.error('%s: %s = %s %s' % (command_name, 'failed, duration', duration, 'seconds'))
        if result.errors:
            for error in result.errors:
                logger.error(' - ' + str(error))

        raise Exception('exception in yql operation')
