# -*- coding: utf-8 -*-
from sandbox import sdk2


def get_yt_env_from_parameters(parameters):
    """
    Создаём словарь с переменными окружения для запуска программ, которые испольуют YT.

    YT_PROXY берётся из parameters.yt_proxy.  YT_TOKEN берётся из Sandbox vault, если parameters.yt_token_vault_name
    не пуст (parameters.yt_token_vault_user может быть пустым).

    :param parameters: sdk2.Task.Parameters с установленными полями yt_proxy, yt_token_vault_user, yt_token_vault_name
    :return: словарь с переменными окружения
    :rtype dict
    """
    env = {
        'YT_PROXY': parameters.yt_proxy
    }
    if parameters.yt_token_vault_name:
        if parameters.yt_token_vault_user:
            token = sdk2.Vault.data(parameters.yt_token_vault_user, parameters.yt_token_vault_name)
        else:
            token = sdk2.Vault.data(parameters.yt_token_vault_name)
        env['YT_TOKEN'] = str(token)
    return env


def create_folder_if_not_exist(yt, folder):
    if not yt.exists(folder):
        yt.mkdir(folder)
