# -*- coding: utf-8 -*-
import logging
from sandbox.projects.common.ya_deploy import release_integration
import sandbox.sandboxsdk as sandbox_sdk
import sandbox.sdk2 as sdk2

from sandbox.projects.common import binary_task
import sandbox.projects.inventori.common.config as config
import sandbox.projects.inventori.common.consts as consts
import sandbox.projects.inventori.common.resources as resources
from sandbox.projects.inventori.common import InventoryRunTaskTemplate
from sandbox.projects.inventori.etl import utils

LOGGER_NAME = 'inventori backtesting generating'
logger = logging.getLogger(LOGGER_NAME)

YT_BACKTESTING_TEST_DIR = config.TEST_YT_PROJECT_DIRECTORY + "/backtesting"
YT_BACKTESTING_PROD_DIR = config.PROD_YT_PROJECT_DIRECTORY + "/backtesting"

YT_ACTIVE_CAMPAIGNS_REGISTRY_DIR_TEST = "//home/inventory/test/campaigns_data/common"
YT_ACTIVE_CAMPAIGNS_REGISTRY_DIR_PROD = "//home/inventory/prod/campaigns_data/common"


class ReleaseParameters(sdk2.Parameters):
    ext_params = binary_task.binary_release_parameters_list(stable=True)
    # release_new_resource, releaseTo = tools.releaseTo_params()
    release_new_resource = sdk2.parameters.Bool(
        'Release new resource when it is created',
        default=False,
        required=True,
    )
    ttl = sdk2.parameters.Integer('TTL for released resource (days, always; 0 for inf)', default=30,
                                  required=True)

    with release_new_resource.value[True]:
        with sdk2.parameters.RadioGroup('Automatically release resource to') as releaseTo:
            for val in sandbox_sdk.sandboxapi.RELEASE_STATUSES:
                releaseTo.values[val] = releaseTo.Value(value=val)


class InventoriBacktestingDbMaker(release_integration.ReleaseToYaDeployTask2,
                                  InventoryRunTaskTemplate.InventoryRunTaskTemplate,
                                  binary_task.LastBinaryTaskRelease):
    class Context(sdk2.Task.Context):
        has_new_resource = False

    class Requirements(sdk2.Requirements):
        disk_space = 100 * 1024  # 100 GiB

        # Requirements for multislot agents
        cores = 1  # < 16
        ram = 512  # 512 MiB < 64 GiB

        class Caches(sdk2.Requirements.Caches):
            pass  # Do not use any shared caches (required for running on multislot agent)

    class Parameters(InventoryRunTaskTemplate.get_run_params(
        resources.InventoriBacktestingDatabase,
        resources.InventoriBacktestingDatabase.InventoriTaskParams,
        base_class=ReleaseParameters
    )):
        pass

    def get_yp_oauth_token(self):
        return sdk2.Vault.data('INVENTORI_YP_TOKEN')

    def on_save(self):
        binary_task.LastBinaryTaskRelease.on_save(self)
        InventoryRunTaskTemplate.InventoryRunTaskTemplate.on_save(self)

    def on_execute(self):
        super(InventoriBacktestingDbMaker, self).on_execute()

        yt_backtesting_data_folder = '{}/result'.format(self.task_params.yt_backtesting_dir)

        archive_created = utils.read_tables_and_create_archive(
            logger=logger,
            log_processor=lambda: sdk2.helpers.ProcessLog(self, logger=LOGGER_NAME),
            yt_proxy=self.task_params.yt_proxy,
            yt_token=self.task_params.yt_token,
            yt_data_folder=yt_backtesting_data_folder,
            csv_tables_prefix_to_columns=consts.CSV_FORMAT_BACKTESTING_TABLES_PREFIX_TO_COLUMNS,
            json_tables_prefix_to_columns=consts.JSON_FORMAT_BACKTESTING_TABLES_PREFIX_TO_COLUMNS,
        )
        if archive_created:
            resource = sdk2.ResourceData(
                resources.InventoriBacktestingDatabase(
                    self,
                    'Inventori backtesting database',
                    consts.PLATFORM_YT_ARCHIVE_NAME
                )
            )

            resource.ready()
            self.Context.has_new_resource = True

    def on_success(self, prev_status):
        utils.send_email_and_deploy(self, prev_status)
