# -*- coding: utf-8 -*-
import logging
import subprocess
import sys

import sandbox.common.types.notification as ctn
# import sandbox.sandboxsdk as sandbox_sdk
# import sandbox.sandboxsdk.environments as sandbox_environments
import sandbox.sdk2 as sdk2

from sandbox.projects.common import binary_task
import sandbox.projects.inventori.common.consts as consts
import sandbox.projects.inventori.common.resources as resources
from sandbox.projects.rope import RunTaskTemplate
from sandbox.projects.inventori.etl import utils

# from sandbox.projects.common.ya_deploy import release_integration

VALIDATION_ERROR_CODE = 99

LOGGER_NAME = 'inventori traffic generating'

VERSION = None

try:
    from library.python import svn_version
    VERSION = str(svn_version.svn_revision())
except ImportError:
    pass

logger = logging.getLogger(LOGGER_NAME)


# class ReleaseParameters(sdk2.Parameters):
#     # # release_new_resource, releaseTo = utils.releaseTo_params()
#     # release_new_resource = sdk2.parameters.Bool(
#     #     'Release new resource when it is created',
#     #     default=False,
#     #     required=True,
#     # )
#     # ttl = sdk2.parameters.Integer('TTL for released resource (days, always; 0 for inf)', default=30,
#     #                               required=True)
#     #
#     # with release_new_resource.value[True]:
#     #     with sdk2.parameters.RadioGroup('Automatically release resource to') as releaseTo:
#     #         for val in sandbox_sdk.sandboxapi.RELEASE_STATUSES:
#     #             releaseTo.values[val] = releaseTo.Value(value=val)
#     #
#     # prepare_new_version_of_logs = sdk2.parameters.Bool(
#     #     "Preparing new database (if not - download files from 'result' folder on YT)",
#     #     default=False)
#
#     # yt_result_database_dir = sdk2.parameters.String('Path to result yt database')
#     tables_fields = sdk2.parameters.Dict(
#         'Tables and fields to make archive with tar.gz',
#         default=consts.JSON_FORMAT_TABLES_PREFIX_TO_COLUMNS,
#     )
#     pass


class ReleaseParameters(sdk2.Parameters):
    ext_params = binary_task.binary_release_parameters_list(stable=True)


class InventoriDbMaker(
    # release_integration.ReleaseToYaDeployTask2,
    RunTaskTemplate.TaskParamsTemplate,
    binary_task.LastBinaryTaskRelease,
):
    class Context(sdk2.Task.Context):
        has_new_resource = False

    class Requirements(sdk2.Requirements):
        disk_space = 80 * 1024  # 80 Gb for data (all necessary indices + archive)
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(RunTaskTemplate.get_run_params(
        resources.InventoriDbMakerBinaries.InventoriTaskParams,
        base_class=ReleaseParameters
    )):
        use_default_tables_fields = sdk2.parameters.Bool(
            'Use defaults from tables_fields',
            description='See defaults in arc '
                        'https://a.yandex-team.ru/arc_vcs/sandbox/projects/inventori/common/consts.py'
                        '{}'.format('?rev={}'.format(VERSION) if VERSION else ''),
            default=False,
            do_not_copy=True,
        )
        tables_fields_default = consts.JSON_FORMAT_TABLES_PREFIX_TO_COLUMNS
        with use_default_tables_fields.value[False]:
            tables_fields = sdk2.parameters.Dict(
                'Tables and fields to make archive with tar.gz',
                default=tables_fields_default,
            )

    def on_save(self):
        binary_task.LastBinaryTaskRelease.on_save(self)
        if self.Parameters.use_default_tables_fields:
            self.Parameters.tables_fields = self.Parameters.tables_fields_default
            self.Parameters.use_default_tables_fields = False

    def get_yp_oauth_token(self):
        return sdk2.Vault.data("INVENTORI_YP_TOKEN")

    def process_subprocess_error(self, ex):
        """
        Process subprocess exception
        :type ex: subprocess.CalledProcessError
        """
        if ex.returncode == VALIDATION_ERROR_CODE:
            self.server.notification(
                subject='VALIDATION FAIL for task #{task_id}'.format(task_id=self.id),
                recipients=['inventori-monitoring@yandex-team.ru'],
                transport=ctn.Transport.EMAIL,
                type=ctn.Type.HTML,
                charset=ctn.Charset.UTF,
                task_id=self.id,
                view=ctn.View.EXECUTION_REPORT,
            )
            sys.stderr.write('VALIDATION FAIL')
        else:
            super(InventoriDbMaker, self).process_subprocess_error(ex)

    def on_execute(self):
        binary_task.LastBinaryTaskRelease.on_execute(self)
        super(InventoriDbMaker, self).on_execute()

        archive_created = utils.read_tables_and_create_archive(
            logger=logger,
            log_processor=lambda: sdk2.helpers.ProcessLog(self, logger=LOGGER_NAME),
            yt_proxy=self.task_params.yt_proxy,
            yt_token=self.task_params.yt_token,
            yt_data_folder=self.task_params.yt_current_archive_dir,
            csv_tables_prefix_to_columns={},
            json_tables_prefix_to_columns=self.Parameters.tables_fields
        )

        if archive_created:
            resource = sdk2.ResourceData(
                resources.InventoriDatabase(
                    self,
                    'Inventori database in tar.gz',
                    consts.PLATFORM_YT_ARCHIVE_NAME
                )
            )

            resource.ready()
            self.Context.has_new_resource = True

    # def on_success(self, prev_status):
    #     utils.send_email_and_deploy(self, prev_status)
