from sandbox import sdk2
from sandbox.projects.iot.common.docker import BuildIotDockerImage
from sandbox.projects.iot.common.resources import BulbasaurDockerImage


class BuildBulbasaurDockerImage(BuildIotDockerImage):
    """
    Task builds bulbasaur docker image
    """

    class Requirements(sdk2.Task.Requirements):
        disk_space = 30000

    class Parameters(BuildIotDockerImage.Parameters):
        docker_package = sdk2.parameters.String(
            'Bulbasaur server package', default='quasar/iot/bulbasaur/pkg.json', required=True,
        )

    def on_execute(self):
        arcadia_url = self.get_arcadia_url()
        task_description = 'YaPackage subtask of BuildBulbasaurDockerImage; parent task_id={id}'.format(id=self.id)

        with self.memoize_stage.subtask_launch:
            docker_image = BulbasaurDockerImage(self, 'Build from {url}'.format(url=arcadia_url), 'bulbasaur-docker-image')
            self.build_package(
                task_description=task_description,
                arcadia_url=arcadia_url,
                path_to_package=self.Parameters.docker_package,
                resource_type=BulbasaurDockerImage.name,
                resource=docker_image,
            )
