# -*- coding: utf-8 -*-
from sandbox import sdk2
import logging
import json
import requests
import time

"""
IOTUIDutyTicket

Сендбоксовая фиговина, которая каждую неделю закрывает/открывает дежурные тикеты, а конкретно:
    * Берет текущего дежурного
    * Заводит новый тикет на него в QUASARUI с нужными датами/компонентами/спринтом/доской/описанием/наблюдателями и т п
    * Связывает старый тикет
    * Закрывает старый тикет
"""


class IOTUIDutyTicket(sdk2.Task):
    debug = True
    st_quasar_ui_board_id = 7618
    st_close_transition_id = 'close'

    def log_obj(self, obj):
        if self.debug:
            logging.info(json.dumps(obj, indent=4, sort_keys=True))

    def log_response(self, response):
        self.log_obj(response.json())

    # main
    def on_execute(self):
        self.init_globals()
        self.st_create_issue(self.make_duty_issue())
        self.st_close_issue(self.st_current_duty_issue['key'])

    # подготовка данных
    def init_globals(self):
        st_token = sdk2.yav.Secret('sec-01g13xgyw3ebvrt8yyf8nmhp69', 'ver-01g3rrs3na7e32rfwkanpsgr0r').data()['st']
        self.st_headers = {'Authorization': 'OAuth %s' % (st_token), 'Content-Type': 'application/json'}

        abc_token = sdk2.yav.Secret('sec-01g13xgyw3ebvrt8yyf8nmhp69', 'ver-01g3rrs3na7e32rfwkanpsgr0r').data()['abc']
        self.abc_headers = {'Authorization': 'OAuth %s' % (abc_token), 'Content-Type': 'application/json'}

        self.st_current_duty_issue = self.st__get_current_duty_issue()
        self.st_current_sprint_id = self.st__get_current_sprint_id()
        self.st_open_release_issues = self.st__get_open_release_issue_keys()
        self.st_open_release_issue_keys = list(map(lambda issue: issue['key'], self.st_open_release_issues))
        self.st_open_release_issue_keys_iot = list(map(lambda issue: issue['key'], filter(lambda issue: 'iot_ui' in issue['tags'], self.st_open_release_issues)))
        self.st_open_release_issue_keys_quasar = list(map(lambda issue: issue['key'], filter(lambda issue: 'quasar_ui' in issue['tags'], self.st_open_release_issues)))

        self.log_obj(self.st_open_release_issue_keys_iot)
        self.log_obj(self.st_open_release_issue_keys_quasar)

        self.abc_current_duty = self.abc__get_current_duty()
        self.abc_duty_members = self.abc__get_current_duty_member_logins()

    # ABC: список логинов всех дежурных
    def abc__get_current_duty_member_logins(self):
        response = requests.get(
            'https://abc-back.yandex-team.ru/api/v4/services/members/?service__slug=alice_iot&role__code=frontend_developer&fields=person.login',
            headers=self.abc_headers,
            verify=False)
        self.log_response(response)

        return list(map(lambda x: x['person']['login'], response.json()['results']))

    # ABC: инфа по текущему дуржству (login, start, end)
    def abc__get_current_duty(self):
        response = requests.get(
            'https://abc-back.yandex-team.ru/api/v4/duty/on_duty/?service__slug=alice_iot&schedule__slug=frontend-duty&fields=person.login,start,end',
            headers=self.abc_headers,
            verify=False)
        self.log_response(response)

        on_duty = response.json()[0]

        return {
            "login": on_duty['person']['login'],
            "start": on_duty['start'],
            "end": on_duty['end']
        }

    # ST: id текущего спринта
    def st__get_current_sprint_id(self):
        response = requests.get(
            'https://st-api.yandex-team.ru/v2/boards/%s/sprints' % (self.st_quasar_ui_board_id),
            headers=self.st_headers,
            verify=False)
        self.log_response(response)

        return response.json()[0]['id']

    # ST: открытый дежурный тикет
    def st__get_current_duty_issue(self):
        response = requests.get(
            'https://st-api.yandex-team.ru/v2/issues?filter=queue:quasarui&filter=components:113763&filter=status:inProgress',
            headers=self.st_headers,
            verify=False)
        self.log_response(response)

        return response.json()[0]

    # ST: открытый дежурный тикет
    def st__get_open_release_issue_keys(self):
        response = requests.post(
            'https://st-api.yandex-team.ru/v2/issues/_search?fields=key,tags',
            headers=self.st_headers,
            verify=False,
            data=json.dumps({
                "query": "Queue: SEAREL AND Status: !Closed AND (Tags: \"iot_ui\" OR Tags: \"quasar_ui\")"
            }))
        self.log_response(response)

        return response.json()
        return list(map(lambda x: x['key'], response.json()))

    # ST: закрыть тикет
    def st_close_issue(self, issue_id):
        response = requests.post(
            'https://st-api.yandex-team.ru/v2/issues/%s/transitions/close/_execute' % (issue_id),
            headers=self.st_headers,
            verify=False,
            data=json.dumps({
                "resolution": "fixed"
            }))
        self.log_response(response)

    # ST: создать тикет
    def st_create_issue(self, issue):
        response = requests.post(
            'https://st-api.yandex-team.ru/v2/issues/',
            headers=self.st_headers,
            verify=False,
            data=json.dumps(issue))
        self.log_response(response)

        time.sleep(180)

    # Сформировать новый дежурный тикет
    def make_duty_issue(self):
        tests_st_filter_link = 'https://st.yandex-team.ru/issues/'\
                               '?_g=status&_f=type+priority+key+summary+updated+lastCommentUpdatedAt+goals+modifier+parent'\
                               '&_q=Queue%3A+quasarui+AND+Status%3A+%21+Закрыт+AND+%28Tags%3A+можно_автоматизировать+%29'

        release_tickets_description = '\n\n**Открытые релизы (на начало дежурства):**'

        if len(self.st_open_release_issue_keys):
            for ticket_key in self.st_open_release_issue_keys_iot:
                release_tickets_description += '\n* https://st.yandex-team.ru/' + ticket_key
            for ticket_key in self.st_open_release_issue_keys_quasar:
                release_tickets_description += '\n* https://st.yandex-team.ru/' + ticket_key
        else:
            release_tickets_description += ' Не найдены'

        return {
            "queue": "QUASARUI",
            "assignee": self.abc_current_duty['login'],
            "summary": "[Дежурство] @%(login)s %(start)s - %(end)s" % self.abc_current_duty,
            "description":  """
                Привет, кто:%(duty_login)s! Подежурим?
                Этот тикет создан тебе в помощь. Собираем тут все, что связано с активностями за это дежурство.

                **Предыдущий дежурный тикет:** https://st.yandex-team.ru/%(previous_issue_key)s

                **Задачи на тесты:** ((%(tests_st_filter_link)s Посмотреть список))

                %(release_tickets_description)s
            """ % {
                "duty_login": self.abc_current_duty['login'],
                "previous_issue_key": self.st_current_duty_issue['key'],
                "release_tickets_description": release_tickets_description,
                "tests_st_filter_link": tests_st_filter_link
            },
            "components": ["Дежурство"],
            "sprint": [self.st_current_sprint_id],
            "boards": [self.st_quasar_ui_board_id],
            "type": "task",
            "storyPoints": 5.0,
            "priority": "normal",
            "links": [{
                "relationship": "depends on",
                "issue": self.st_current_duty_issue['key']
            }],
            "followers": self.abc_duty_members,
        }
