# -*- coding: utf-8 -*-
from sandbox import sdk2
import logging
import json
import requests
import time


class IOTUIRegress(sdk2.Task):

    st_api_url = 'https://st-api.yandex-team.ru/v2/issues/'

    def on_execute(self):
        secret = sdk2.yav.Secret("sec-01g13xgyw3ebvrt8yyf8nmhp69", "ver-01g38xfeaq3vvfv5wxdwv3nvkp")
        sttoken = secret.data()['st']
        tptoken = secret.data()['tp']
        stheader = {'Authorization': 'OAuth ' + sttoken, "Content-Type": "application/json"}
        tpheader = {'Authorization': 'OAuth ' + tptoken, "Content-Type": "application/json"}
        release = 'webview'
        ticket = self.get_release(stheader)

        listruns = self.get_listruns(release, ticket, tpheader, stheader)
        description = self.get_description(release, ticket, listruns)
        self.add_tag(release, ticket, stheader)
        self.create_ticket({
            "queue": "ALICE",
            "type": "task",
            "summary": "Кейсы по релизу UI",
            "description": ticket,
            "assignee": {"id": "levkovskayama"},
            "parent": ticket,
            "tags": 'cases',
        }, stheader)
        self.create_ticket({
            "queue": "ALICEASSESSORS",
            "type": "task",
            "parent": ticket,
            "summary": "Тестирование релиза " + release + " " + ticket,
            "description": description,
        }, stheader)

        current_duty_issue = self.st__get_current_duty_issue(stheader)

        if current_duty_issue:
            self.st__post_comment(
                current_duty_issue['key'],
                'Новый релизный тикет: %s' % ticket,
                [current_duty_issue['assignee']['id']] if current_duty_issue.get('assignee') is not None else [],
                stheader)

    def st__get_current_duty_issue(self, stheader):
        response = requests.get(
            'https://st-api.yandex-team.ru/v2/issues?filter=queue:quasarui&filter=components:113763&filter=status:inProgress',
            headers=stheader,
            verify=False)
        issues = response.json()

        return issues[0] if len(issues) != 0 else None

    def st__post_comment(self, target_issue_key, comment, summonees, stheader):
        body = {
            "text": comment,
            "summonees": summonees
        }

        requests.post(
            'https://st-api.yandex-team.ru/v2/issues/%s/comments' % target_issue_key,
            headers=stheader,
            verify=False,
            data=json.dumps(body))

    def get_suites(self, release, tpheader):
        if release not in ['webview', 'smarthome']:
            logging.warn('Wrong release tag')
            return []

        params = {"include": "id,title,tags", "expression": '''{{"type": "EQ", "key": "tags", "value": "{tag}" }}'''.format(tag=release)}
        resp = requests.get('https://testpalm-api.yandex-team.ru/testsuite/iot-ui/', headers=tpheader, params=params, verify=False)
        if not resp.text:  # не получили сьюты
            return []
        else:
            return resp.json()

    def get_release(self, stheader):
        time.sleep(180)
        resp = requests.get('https://st-api.yandex-team.ru/v2/issues?filter=queue:SEAREL&filter=components:107078&filter=status:open', headers=stheader, verify=False)

        return resp.json()[0]['key']

    def get_listruns(self, release, ticket, tpheader, stheader):
        list_runs_for_assessors = []

        suites = self.get_suites(release, tpheader)
        if not suites:
            logging.warn('Can not get suites by ' + release + ' tag')
        else:
            # logging.info(suites)
            for item in suites:
                title = item["title"]
                suite_id = item["id"]
                run = self.create_run(suite_id, title, ticket, tpheader, stheader)
                if run == 'error':
                    logging.warn('Can not create run ' + title)
                else:
                    run_id = run['id']
                    list_runs_for_assessors.append(title + ' ' + 'https://testpalm.yandex-team.ru/iot-ui/testrun/' + str(run_id))
        return list_runs_for_assessors

    def get_description(self, release, ticket, listruns):
        runs_in_ticket = ''
        for el in listruns:
            runs_in_ticket += el + '\n'

        description = "==Релиз " + release + "\n"
        description += "\n"
        description += "Релизный тикет " + ticket + "\n"
        description += "\n"
        description += "==Настройки окружения\n"
        description += "\n"
        description += "===1. Залипнуть в тестид 268705 и убедиться, что отображается ((https://jing.yandex-team.ru/files/osennikovak/2022-05-24T12:26:19Z.0d90c94.png номер версии))\n"
        description += "\n"
        description += "<{Если не получилось\n"
        description += "\n"
        description += "#|\n"
        description += "||\n"
        description += "\n"
        description += "**ПП**\n"
        description += "\n"
        description += "|\n"
        description += "\n"
        description += "%%yellowskin://?url=https%3A%2F%2Frctemplates-shared.hamster.yandex.ru"
        description += "%2Fquasar%3Fsrcrwr%3DQUASAR_HOST%253Aquasar.yandex.ru%26srcrwr%3DBILLING_HOST%253Aquasar.yandex.ru%26srcrwr%3DIOT_HOST%253Aiot.quasar.yandex.ru%%\n"
        description += "||\n"
        description += "||\n"
        description += "\n"
        description += "**Десктоп**\n"
        description += "\n"
        description += "|\n"
        description += "\n"
        description += "https://rctemplates-shared.hamster.yandex.ru/quasar?srcrwr=QUASAR_HOST%3Aquasar.yandex.ru&srcrwr=BILLING_HOST%3Aquasar.yandex.ru&srcrwr=IOT_HOST%3Aiot.quasar.yandex.ru"
        description += "\n"
        description += "\n"
        description += "||\n"
        description += "|#\n"
        description += "}>\n"
        description += "===2. Тест-раны iotapp тестируем в приложении Дом с Алисой. Тест-ранаы searchapp - на вкладке Устройства в ПП. "
        description += "Тест-ран Моя Алиса тестировать в табах Алисы в ПП (открыть диалог с Алисой по тапу на окникс и перейти на вкладку Умный дом).\n"
        description += "\n"
        description += "==Список ранов\n"
        description += "\n"
        description += '<[' + runs_in_ticket + ']>\n'
        description += "===Окружение\n"
        description += "\n"
        description += "====Android ПУДЯ:\n"
        description += "\n"
        description += "https://disk.yandex.ru/d/jKavOFiP1BlSnA\n"
        description += "\n"
        description += "====iOS ПУДЯ:\n"
        description += "\n"
        description += "Ставим из стора приложение TestFlight  (это приложение для бета-тестов приложений)"
        description += " и сканируем QR код камерой:\n"
        description += "200x200:https://jing.yandex-team.ru/files/lawyard/QR_Coder_-_Generator_QR_kodov_2021-10-28_16-29-09.png\n"
        description += "\n"
        description += "Либо кликаем ссылку:\n"
        description += "https://testflight.apple.com/join/0zJ4Lilb\n"
        description += "\n"
        description += "===Нюансы\n"
        description += "\n"
        description += "- Тестируем приложения Дом с Алисой и ПП \n"
        description += "- **Сначала проходим раны с iotapp в приложении "
        description += "Дом с Алисой**\n"
        description += "- Кейсам, которые не вписываются в формат приложения (другие экраны и т.д.) ставим BROKEN, но обязательно пишем в комментариях - кейс пройден в итоге или нет.\n"
        description += "==Инструкция по тестированию\n"
        description += "https://wiki.yandex-team.ru/alicetesting/assessors-and-alice/"

        return description

    def create_ticket(self, data, header):
        raw_data = json.dumps(data, ensure_ascii=False, separators=(",", ": "))
        raw_data = raw_data.encode('utf-8')
        requests.post(self.st_api_url, data=raw_data, headers=header)

    def add_tag(self, release, ticket, header):
        data = {"tags": {"add": release}}
        raw_data = json.dumps(data, ensure_ascii=False, separators=(",", ": "))
        raw_data = raw_data.encode('utf-8')
        resp = requests.patch(self.st_api_url + ticket, data=raw_data, headers=header)
        logging.info(resp, resp.text)
        return resp, resp.text

    def add_testrun_to_st(self, ticket, run, stheader):
        link_run = 'testrun/iot-ui/' + run
        data = {"relationship": "relates", "key": link_run, "origin": "ru.yandex.testpalm"}
        raw_data = json.dumps(data, ensure_ascii=False, separators=(",", ": "))
        raw_data = raw_data.encode('utf-8')

        resp = requests.post(self.st_api_url + ticket + '/remotelinks?notifyAuthor=false&backlink=false', data=raw_data, headers=stheader)
        if not resp.json():
            return []
        return resp

    def create_run(self, suite_id, title, ticket, tpheader, stheader):
        parentIssue = {"id": ticket, "trackerId": "Startrek"}

        url = 'https://testpalm-api.yandex-team.ru/testrun/iot-ui/create/'

        params = {"include": "id,title"}
        payload = {
            "title": title,
            "testSuite": {
                "id": suite_id
            },
            "parentIssue": parentIssue,
        }
        response = requests.post(url, json=payload, params=params, headers=tpheader, verify=False)
        if response.status_code != 200:
            logging.warn("Unable to create testpalm run, code: {code}, body: {body}".format(code=response.status_code, body=response.text))
            return 'error'
        run = next(iter(response.json()), {})
        run_id = run['id']
        self.add_testrun_to_st(ticket, run_id, stheader)
        return run
