from sandbox import sdk2
from sandbox.common.types import task


class BuildIotDockerImage(sdk2.Task):
    """
    Abstract task that builds iot docker images
    """

    # docker info
    DOCKER_REGISTRY = 'registry.yandex.net'
    DOCKER_IMAGE_REPOSITORY = 'quasar'
    DOCKER_USER = 'robot-quasar'
    DOCKER_TOKEN_VAULT_NAME = 'QUASAR_ROBOT_DOCKER_REGISTRY_TOKEN'
    DOCKER_PUSH_IMAGE = True

    class Parameters(sdk2.Task.Parameters):
        arcadia_url = sdk2.parameters.ArcadiaUrl('Svn url for arcadia', required=True)
        revision = sdk2.parameters.String('Revision')
        use_aapi_fuse = sdk2.parameters.Bool('Use ArcadiaApi FUSE')

    def get_arcadia_url(self):
        if not self.Parameters.revision:
            return self.Parameters.arcadia_url
        return '{url}@{rev}'.format(url=self.Parameters.arcadia_url, rev=self.Parameters.revision)

    def build_package(self, task_description, arcadia_url, path_to_package, resource_type, resource):
        build_task = sdk2.Task["YA_PACKAGE"](
            self,
            # task parameters
            description=task_description,
            use_new_format=True,
            # build parameters
            checkout_arcadia_from_url=arcadia_url,
            use_aapi_fuse=self.Parameters.use_aapi_fuse,
            package_type='docker',
            packages=path_to_package,
            # docker parameters
            docker_registry=self.DOCKER_REGISTRY,
            docker_image_repository=self.DOCKER_IMAGE_REPOSITORY,
            docker_user=self.DOCKER_USER,
            docker_token_vault_name=self.DOCKER_TOKEN_VAULT_NAME,
            docker_push_image=self.DOCKER_PUSH_IMAGE,
            # resource parameters
            resource_type=resource_type,
            resource_id=str(resource.id)
        ).enqueue()

        self.Context.subtask_id = build_task.id
        raise sdk2.WaitTask([build_task], task.Status.Group.FINISH, wait_all=True)

    def on_execute(self):
        pass

    def on_release(self, additional_parameters):
        sdk2.Task.on_release(self, additional_parameters)
