# -*- coding: UTF-8 -*-

from sandbox import sdk2
import client
import random
import logging
from sandbox.projects.common.yasm import push_api


logger = logging.getLogger(__name__)


class QuasarIotIrAcMonitoring(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        with sdk2.parameters.Group('Tuya'):
            client_id = sdk2.parameters.Vault('Tuya client id', required=True)
            secret = sdk2.parameters.Vault('Tuya secret', required=True)
            host = sdk2.parameters.String('Tuya API host', default='openapi.tuyaeu.com', required=False)

        with sdk2.parameters.Group('Device'):
            hub_id = sdk2.parameters.String('Hub id', required=True)
            control_id = sdk2.parameters.String('Control external id', required=True)
            remote_index = sdk2.parameters.Integer('Remote index', required=True)

    def on_execute(self):
        tuya = client.TuyaClient(self.Parameters.client_id, self.Parameters.secret, self.Parameters.host)

        # set ac start stage
        payload = {
            'remote_id': self.Parameters.control_id,
            'remote_index': self.Parameters.remote_index,
            'power': 1,
            'mode': 3,
            'wind': 2,
            'temp': 20
        }

        send_action_and_check(tuya, self.Parameters.hub_id, self.Parameters.control_id, payload)

        # set another state
        available_temp_range = range(18, 24)
        available_temp_range.remove(payload['temp'])
        payload['temp'] = random.choice(available_temp_range)

        send_action_and_check(tuya, self.Parameters.hub_id, self.Parameters.control_id, payload)


def send_action_and_check(client, hub_id, control_id, payload):
    try:
        client.post_ir_action(hub_id, payload)
    except Exception, e:
        logger.info('Failed to send action to ac. Reason: {}'.format(e))
        send_error_signal()

    # check state changes
    state = client.get_ac_state(hub_id, control_id)

    if state['temp'] != payload['temp'] or state['wind'] != payload['wind'] \
            or state['mode'] != payload['mode'] or state['power'] != payload['power']:
        logger.info('AC state check failed. Sended state: {}, current state: {}'.format(payload, state))
        send_error_signal()


def send_error_signal():
    push_api.push_signal(
        name="unistat-quasar_bulbasaur_tuya_ac_state_error_dmmm",
        value=1,
        prj='bulbasaur',
        itype='bulbasaur',
    )
