# -*- coding: utf-8 -*-

import logging
import os

from sandbox import sdk2
import sandbox.common.types.task as ctt
import sandbox.common.errors as ce
from sandbox.sdk2.helpers.process import subprocess as sp
from sandbox.projects.common.constants import constants


class IotSpeakerUsersMigrate(sdk2.Task):
    class Parameters(sdk2.Parameters):
        yt_token = sdk2.parameters.Vault('YT_TOKEN', required=True)
        ydb_token = sdk2.parameters.Vault('YDB_TOKEN', required=True)
        ydb_prefix = sdk2.parameters.String('YDB_PREFIX', required=True, default="/ru-prestable/quasar/development/iotdb")
        ydb_endpoint = sdk2.parameters.String('YDB_ENDPOINT', required=True, default="ydb-ru-prestable.yandex.net:2135")

    def on_execute(self):
        path = 'alice/iot/bulbasaur/cmd/migration/08_speaker_users_migrate'
        name = '08_speaker_users_migrate'

        with self.memoize_stage.build:
            logging.info('Building ' + path)
            build_task = sdk2.Task["YA_MAKE"](
                self,
                description='Building ' + path,
                owner=self.owner,
                targets=path,
                arts=os.path.join(path, name),
                build_system=constants.DISTBUILD_BUILD_SYSTEM,
                build_type=constants.RELEASE_BUILD_TYPE,
                clear_build=False,
            )
            logging.info('Finished building ' + path)
            self.Context.build_task_id = build_task.id
            build_task.save().enqueue()
            raise sdk2.WaitTask(build_task, ctt.Status.Group.FINISH + ctt.Status.Group.BREAK, wait_all=True)

        build_task = self.find(None, id=self.Context.build_task_id).first()
        if build_task.status in ctt.Status.Group.BREAK + ctt.Status.Group.SCHEDULER_FAILURE:
            raise ce.TaskError("Subtask unsuccessfully finished with status %s" % build_task.status)

        build_resource = sdk2.Resource["ARCADIA_PROJECT"].find(task=build_task).first()
        bin_path = os.path.join(str(sdk2.ResourceData(build_resource).path), name)

        cmd = [bin_path, '--force-yes']
        os.environ["YT_TOKEN"] = sdk2.Vault.data(self.owner, self.Parameters.yt_token)
        os.environ["YDB_TOKEN"] = sdk2.Vault.data(self.owner, self.Parameters.ydb_token)
        os.environ["YDB_PREFIX"] = self.Parameters.ydb_prefix
        os.environ["YDB_ENDPOINT"] = self.Parameters.ydb_endpoint
        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger("main")) as pl:
            pl.logger.propagate = 1
            sp.check_call(cmd, stdout=pl.stdout, stderr=sp.STDOUT)

        logging.info('done')
