# -*- coding: utf-8 -*-
from sandbox import sdk2
import logging
import json
import requests
from sandbox.sandboxsdk import environments


class ReleaseBugging(sdk2.Task):
    st_api_url = 'https://st-api.yandex-team.ru/v2/issues/'
    board_num = 7618

    testing=False
    sttoken=''  # Add for tests
    abctoken=''  # Add for tests

    class Parameters(sdk2.Task.Parameters):
        ticket = sdk2.parameters.String("ticket", default="ANDSIMON-1")
        isIot = sdk2.parameters.Bool("is iot", default=True)
        isRelease = sdk2.parameters.Bool("is release", default=True)

    class Requirements(sdk2.Task.Requirements):
        environments = (
            environments.PipEnvironment(
                'yandex_tracker_client', version="2.3",
            ),
            environments.PipEnvironment(
                'startrek_client', version="2.5.0"
            ),
        )

    def on_execute(self):
        from startrek_client import Startrek
        logging.info("-----EXECUTE-----")
        ticket = 'ANDSIMON-1' if self.testing else self.Parameters.ticket
        secret = {
            'abc': self.abctoken,
            'st': self.sttoken,
        } if self.testing else sdk2.yav.Secret("sec-01g13xgyw3ebvrt8yyf8nmhp69", "ver-01g3rrs3na7e32rfwkanpsgr0r").data()
        self.ST = Startrek(useragent='robot-mad-hatter', token=secret['st'])
        self.abc_headers = {'Authorization': 'OAuth %s' % (secret['abc']), 'Content-Type': 'application/json'}
        self.st_headers = {'Authorization': 'OAuth %s' % (secret['st']), "Content-Type": "application/json"}
        issue = self.ST.issues[ticket]

        summary = issue.summary

        assignee = {}
        tags = [],
        if self.Parameters.isRelease:
            summary = '#peлизныйбаг ' + summary
            assignee = {'id': self.abc__get_current_duty_member_login()}
            tags = ['нежданчик']
        issue2 = self.ST.issues.create(
            queue='QUASARUI',
            summary=summary,
            type={'name': 'Bug'},
            description=issue.description,
            assignee=assignee,
            tags=tags,
            sprint=[self.st__get_current_sprint_id()],
            boards=[self.board_num],
            followers=self.abc__get_current_duty_member_logins()
        )
        if self.Parameters.isRelease:
            issue2.links.create(issue=self.st__get_open_release_issue_keys(), relationship='is dependent by')
            issue2.links.create(issue=ticket, relationship='is dependent by')

    #  ABC: список логинов всех дежурных
    def abc__get_current_duty_member_logins(self):
        response = requests.get(
            'https://abc-back.yandex-team.ru/api/v4/services/members/?service__slug=alice_iot&role__code=frontend_developer&fields=person.login',
            headers=self.abc_headers,
            verify=False)

        result = list(map(lambda x: x['person']['login'], response.json()['results']))
        response = requests.get(
            'https://abc-back.yandex-team.ru/api/v4/services/members/?service__slug=alice_iot&role__code=functional_tester&fields=person.login',
            headers=self.abc_headers,
            verify=False)

        result.extend(list(map(lambda x: x['person']['login'], response.json()['results'])))

        result.append('lawyard')

        return result

    #  ST: id текущего спринта
    def st__get_current_sprint_id(self):
        if self.Parameters.isRelease:
            response = requests.get(
                'https://st-api.yandex-team.ru/v2/boards/7618/sprints',
                headers=self.st_headers,
                verify=False)

            return response.json()[0]['id']
        else:
            return 114370

    def st__get_current_duty_issue(self):
        response = requests.get(
            'https://st-api.yandex-team.ru/v2/issues?filter=queue:quasarui&filter=components:113763&filter=status:inProgress',
            headers=self.st_headers,
            verify=False)

        return response.json()[0]

    def abc__get_current_duty_member_login(self):
        logging.info("-----GET ABC-----")
        response = requests.get(
            'https://abc-back.yandex-team.ru/api/v4/duty/on_duty/?service__slug=alice_iot&schedule__slug=frontend-duty&fields=person.login,start,end',
            headers=self.abc_headers,
            verify=False)
        logging.info(response)
        on_duty = response.json()[0]

        return on_duty['person']['login']

    def st__get_open_release_issue_keys(self):
        tags = ""
        if self.Parameters.isIot:
            tags = "iot_ui"
        else:
            tags = "quasar_ui"
        response = requests.post(
            'https://st-api.yandex-team.ru/v2/issues/_search?fields=key,tags',
            headers=self.st_headers,
            verify=False,
            data=json.dumps({
                "query": "Queue: SEAREL AND Status: !Closed AND Tags: \"" + tags + "\""
            }))
        if response.status_code != 200:
            return 'ANDSIMON-1'
        return response.json()
