# -*- coding: utf-8 -*-

from sandbox import sdk2


TEAM = ["dieash", "goltsman", "iskostarev", "taube"]
ROBOTS_LIST = ["robot-ipreg", "robot-geogen"]


class IPREG_DATA(sdk2.Resource):
    """
        taggable storage for (almost all?) IPREG-related datafiles (input/external)
    """
    any_arch = True
    executable = False
    releasable = True
    releasers = TEAM + ROBOTS_LIST
    __default_attribute__ = sdk2.parameters.String


class IPREG_EXPORT(sdk2.Resource):
    """
        storage for standard output of IPREG datafiles (exports)
    """
    any_arch = True
    executable = False
    releasable = True
    releasers = TEAM + ROBOTS_LIST


class GEOGEN_WWW_BUNDLE(sdk2.Resource):
    """
        Geogen-www package
    """
    releasable = True
    releasers = TEAM
    release_subscribers = TEAM
