import os.path
import shutil

from sandbox import sdk2

from sandbox.projects.irt.common import create_irt_data, archive_irt_data
from sandbox.projects.irt.IrtBuild import IrtBuild


class BuildIrtBot(IrtBuild):
    """
    Class for building IRT Bot binary
    """
    YP_TOKEN_YAV_SECRET_ID = 'sec-01e584paredpyfddwajnhkr9xp'

    class Parameters(IrtBuild.Parameters):
        with sdk2.parameters.Output():
            build_revision = sdk2.parameters.Integer("Build revision")

    def on_execute(self):
        targets = ['rt-research/common/tools/bot']
        binary_files, revision = self.build(
            targets,
            str(self.path('build')),
            platform=self.Parameters.platform,
            revision=self.Parameters.arcadia_revision,
            arc_review=self.Parameters.arcanum_review
        )

        self.Parameters.build_revision = revision

        if len(binary_files) != 1:
            raise RuntimeError('Wrong count of binary files')

        result = create_irt_data(self,
                                 'irt_bot',
                                 'IRT telegram bot binary {} {}'.format(self.Parameters.arcadia_revision, self.Parameters.platform),
                                 [],
                                 build_revision=revision,
                                 platform=self.Parameters.platform,
                                 review=self.Parameters.arcanum_review,
                                 targets=','.join(targets),
                                 archive='tgz')

        dst_path = os.path.join(str(result.root_path), 'bot')
        os.mkdir(dst_path)
        shutil.copy(binary_files[0], os.path.join(dst_path, 'bin'))
        archive_irt_data(result)
