import os.path
import shutil


from sandbox.projects.irt.common import create_irt_data
from sandbox.projects.irt.IrtBuild import IrtBuild


class BuildMultikJupyter(IrtBuild):
    """
    Class for building MultiK Jupyter kernels
    """

    def on_execute(self):
        targets = ['rt-research/multik/tools/jupyter',
                   'rt-research/multik/tools/jupyter/py2',
                   'rt-research/multik/tools/jupyter/py3',
                   ]

        binary_files, revision = self.build(
            targets,
            str(self.path('build')),
            platform=self.Parameters.platform,
            revision=self.Parameters.arcadia_revision,
            arc_review=self.Parameters.arcanum_review
        )

        result = create_irt_data(self,
                                 'multik_jupyter',
                                 'Multik Jupyter kernels {} {}'.format(self.Parameters.arcadia_revision, self.Parameters.platform),
                                 [],
                                 build_revision=revision,
                                 platform=self.Parameters.platform,
                                 review=self.Parameters.arcanum_review,
                                 targets=','.join(targets))

        for bin_file in binary_files:
            dir_name, file_name = os.path.split(bin_file)
            shutil.move(dir_name if file_name == 'kernel' else bin_file, str(result.root_path))
