from sandbox.projects.common.BaseCompareYaMakeOutputsTask import BaseCompareYaMakeOutputsTask
from sandbox import sdk2

from os.path import join as pj
from subprocess import check_call
import os


class BlrtJsonDiff(sdk2.Resource):
    auto_backup = True


class BlrtCompareTestOutputJson(BaseCompareYaMakeOutputsTask):
    DUMPS_DIR = "dumps"
    DIFF_RESULTS_DIR = "diff_results"

    def compare(self, build_output1, build_output2, testing_out_stuff_dir):
        check_call([
            pj(build_output2, testing_out_stuff_dir, "difftool"),
            "--old-dir", pj(build_output1, testing_out_stuff_dir, self.DUMPS_DIR),
            "--new-dir", pj(build_output2, testing_out_stuff_dir, self.DUMPS_DIR),
            "--diff-dir", self.DIFF_RESULTS_DIR,
        ])

        if not os.path.exists(self.DIFF_RESULTS_DIR):
            return None

        return self.build_diff_resource_and_get_summary()

    def build_diff_resource_and_get_summary(self):
        summary_path = pj(self.DIFF_RESULTS_DIR, "summary.html")
        with open(summary_path, "r") as summary_file:
            summary = summary_file.read()
        os.remove(summary_path)

        diff_resource = BlrtJsonDiff(self, "BLRT test diff", self.DIFF_RESULTS_DIR, ttl=14)
        sdk2.ResourceData(diff_resource).ready()
        details_link = self.server.resource[diff_resource.id][:]["http"]["proxy"]
        return summary.replace("{details_link}", str(details_link))
