from sandbox import sdk2
from sandbox.projects.CreateTextResource import CreateTextResource
from sandbox.projects.common.nanny import nanny


class BlrtResourceBase(sdk2.Resource):
    auto_backup = True
    calc_md5 = True
    releasable = True
    releasers = ['IRT']
    share = True


class BlrtCmBinaries(BlrtResourceBase):
    arcadia_build_path = 'robot/blrt/packages/cm_binaries'


class BlrtCmpy(BlrtResourceBase):
    arcadia_build_path = 'robot/blrt/packages/cmpy'


class BlrtCmWorkerConfigs(BlrtResourceBase):
    arcadia_build_path = 'robot/blrt/packages/worker_config'


class BlrtWorker(BlrtResourceBase):
    arcadia_build_path = 'robot/blrt/packages/worker'


class BlrtWorkerConfigs(BlrtResourceBase):
    arcadia_build_path = 'robot/blrt/packages/worker_config'


class BlrtPreparePerlEnv(BlrtResourceBase):
    arcadia_build_path = 'robot/blrt/packages/prepare_perl_env'


class BlrtLogfetcher(BlrtResourceBase):
    arcadia_build_path = 'robot/blrt/packages/logfetcher'


class BlrtBmBannerlandLib(BlrtResourceBase):
    arcadia_build_path = 'robot/blrt/packages/bm_bannerland_lib'


class BlrtResharder(BlrtResourceBase):
    arcadia_build_path = 'robot/blrt/packages/resharder'


class BlrtTaskWorker(BlrtResourceBase):
    arcadia_build_path = 'robot/blrt/packages/task_worker'


class BlrtSelectionRankWorker(BlrtResourceBase):
    arcadia_build_path = 'robot/blrt/packages/selection_rank_worker'


class BlrtOfferWorker(BlrtResourceBase):
    arcadia_build_path = 'robot/blrt/packages/offer_worker'


class BlrtPreviewWorker(BlrtResourceBase):
    arcadia_build_path = 'robot/blrt/packages/preview_worker'


class BlrtCustomWorkerPerfConfig(BlrtResourceBase):
    pass


class BlrtCustomWorkerDynConfig(BlrtResourceBase):
    pass


class BlrtCustomMultidcWorkerPerfConfig(BlrtResourceBase):
    pass


class BlrtCustomMultidcWorkerDynConfig(BlrtResourceBase):
    pass


class BlrtCustomPreviewWorkerConfig(BlrtResourceBase):
    pass


class BlrtViewer(BlrtResourceBase):
    arcadia_build_path = 'robot/blrt/packages/viewer'


class BlrtCreateTextResource(nanny.ReleaseToNannyTask, CreateTextResource):
    type = 'BLRT_CREATE_TEXT_RESOURCE'
