from sandbox.projects.CreateTextResource import CreateTextResource

from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.errors import SandboxTaskFailureError
from sandbox.projects.common import string
from sandbox.projects.common.nanny import nanny

import json
import google.protobuf.text_format as text


def load_file(filename, proto_obj=None):
    path = filename
    with open(path, 'r') as stream:
        if not proto_obj:
            return json.load(stream)
        text.Parse(stream.read(), proto_obj)
    return proto_obj


class BlrtCreateCustomConfig(nanny.ReleaseToNannyTask, CreateTextResource):

    type = 'BLRT_CREATE_CUSTOM_CONFIG'

    def on_execute(self):
        from robot.blrt.protos.blrt_config_pb2 import (
            TBlrtConfig as BlrtConfig
        )
        resource = channel.sandbox.get_resource(self.ctx['out_resource_id'])

        resource_content = self.ctx['resource_file_content'].replace('\r\n', '\n').encode('utf-8')
        with open(resource.path, "w") as file:
            file.write(resource_content)

        del self.ctx['resource_file_content']

        try:
            load_file(resource.path, BlrtConfig())
        except Exception:
            raise SandboxTaskFailureError('Error of config format')

        resource_attributes = self.ctx.get('resource_attrs')
        if resource_attributes:
            for k, v in string.parse_attrs(resource_attributes).iteritems():
                channel.sandbox.set_resource_attribute(resource.id, k, v)

        if self.ctx.get('store_forever', False):
            channel.sandbox.set_resource_attribute(resource.id, 'ttl', 'inf')
