# -*- coding: utf-8 -*-

import os
import tempfile
import shutil

import sandbox.projects.release_machine.core.const as rm_const
from sandbox import sdk2
from sandbox.projects.common import binary_task
from sandbox.projects.irt.common import create_irt_data


class BmgenCatalogiaCampaigns(binary_task.LastBinaryTaskRelease, sdk2.Task):
    """
    Generate MySQL-request for updating info in Catalogia's MySQL-table "Campaigns".
    """
    class Parameters(sdk2.Parameters):
        ext_params = binary_task.binary_release_parameters(stable=True)
        yt_campaigns_prev = sdk2.parameters.String(
            "Copy of previous version of 'Campaigns' Direct YT-table",
            default="//home/catalogia/tmp/__test__previous_direct_campaigns",
        )
        yt_cluster = sdk2.parameters.String(
            "YT cluster",
            default="hahn",
        )
        yt_pool = sdk2.parameters.String(
            "Pool for YT-operations",
            default="catalogia",
        )

    def on_execute(self):
        import irt.iron.options as iron_opts
        import irt.bmgen.catalogia_campaigns as cat_camps

        os.environ["SANDBOX_OAUTH_TOKEN"] = sdk2.Vault.data("sandbox_oauth_token")
        os.environ["YT_TOKEN"] = sdk2.Vault.data("yql_robot_bm_admin")
        os.environ["YT_POOL"] = "catalogia"

        resource_type = iron_opts.get("campaigns_mysql_diff_sb_resource_type")
        curr_task_type = self.Parameters.binary_executor_release_type

        with tempfile.NamedTemporaryFile(delete=False) as tmp_file:
            if cat_camps.get_request_for_updating_mysql_campaigns(
                self.Parameters.yt_campaigns_prev,
                self.Parameters.yt_cluster,
                tmp_file,
                "{}{}".format(
                    "" if curr_task_type == rm_const.ReleaseStatus.stable else "__{}__".format(curr_task_type),
                    resource_type,
                ),
                self.Parameters.yt_pool,
                self.Parameters.binary_executor_release_type == rm_const.ReleaseStatus.stable,
            ):

                campaigns_mysql_diff = create_irt_data(
                    self,
                    resource_type,
                    "Обновление таблицы 'Campaigns' для MySQL базы Каталогии",
                    [iron_opts.get("campaigns_mysql_update_request_path")],
                    patch_status="new",
                    ttl=30,
                    check_task_mode=True,
                )
                shutil.move(tmp_file.name, campaigns_mysql_diff.filenames[0])
