# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.projects.irt.common import create_irt_data, YTParameters
from sandbox.projects.common import binary_task


class BmgenFreqWordforms(binary_task.LastBinaryTaskRelease, sdk2.Task):
    """
    Advq Wordforms for Bannerland
    """

    class Parameters(YTParameters):
        advq_bnr_table = sdk2.parameters.String(
            "Temporary YT table for sum of ADVQ hits and banners hits",
            default="//home/catalogia/tmp/advq_bnr_table",
        )
        ext_params = binary_task.binary_release_parameters(stable=True)

    def on_execute(self):
        import yt.wrapper as yt
        import irt.sandbox as irt_sb
        from irt.bmgen.wordforms import generate_frequency_wordforms

        sb_client = irt_sb.Sandbox(sdk2.Vault.data("sandbox_oauth_token"))
        if not sb_client.new_bmgen_resource_needed("freq_wordforms"):
            return

        yt.config["proxy"]["url"] = self.Parameters.yt_proxy + ".yt.yandex.net"
        yt.config["token"] = sdk2.Vault.data(self.Parameters.yt_token_vault_name)
        yt.config["spec_defaults"] = {"pool": self.Parameters.yt_pool}

        generate_frequency_wordforms(
            dst_yt_table=self.Parameters.advq_bnr_table,
            yt_client=yt,
        )

        freq_wordforms = create_irt_data(
            self,
            "freq_wordforms",
            "Словоформы для Bannerland-а",
            ["rt-research/broadmatching/work/Norm/freq_wordforms"],
            ttl=30,
            check_task_mode=True,
        )
        with open(freq_wordforms.filenames[0], "wb") as f:
            for row in yt.read_table(self.Parameters.advq_bnr_table, unordered=False):
                f.write("{}\t{}\n".format(row["hits"], row["word"]))

        yt.remove(self.Parameters.advq_bnr_table)
