# -*- coding: utf-8 -*-

import os

from sandbox import sdk2
from sandbox.projects.common import binary_task
from sandbox.projects.irt.common import create_irt_data, do_bmgendict_copy


class BmgenMarketData(binary_task.LastBinaryTaskRelease, sdk2.Task):
    """
    Generate useful data from Yandex.Market about models/vendors/categories etc. Plus prepare comptrie and subphraser data.
    """

    class Parameters(sdk2.Parameters):
        ext_params = binary_task.binary_release_parameters(stable=True)

    def on_execute(self):
        import irt.iron.options as iron_opts
        from irt.bmgen.market_data import get_id_category_vendor_model, write_idcatvenmod_to_file, write_subphraser_comptrie, write_staticmap_data

        opts = iron_opts.get_all()
        raw_data = get_id_category_vendor_model()
        id_category_vendor_model = create_irt_data(
            self,
            "marketdata_id_category_vendor_model",
            "Данные Маркета по моделям товарам, их брендам, категориям и пр. информации",
            [os.path.join(opts["bm_root"], opts["market_data_rel_path"])],
            ttl=30,
            check_task_mode=True,
        )
        write_idcatvenmod_to_file(raw_data, id_category_vendor_model.filenames[0])

        marketdata_subphraser = create_irt_data(
            self,
            "marketdata_subphraser",
            "Данные Маркета для subphraser-а: comptrie и staticmap",
            [
                os.path.join(opts["bm_root"], opts["market_comptrie_rel_path"]),
                os.path.join(opts["bm_root"], opts["market_staticmap_rel_path"]),
            ],
            ttl=30,
            check_task_mode=True,
        )
        write_subphraser_comptrie(
            raw_data,
            marketdata_subphraser.filenames[0],
        )
        write_staticmap_data(raw_data, marketdata_subphraser.filenames[1])

        do_bmgendict_copy(self, id_category_vendor_model)
        do_bmgendict_copy(self, marketdata_subphraser)
