# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.projects.common import binary_task
from sandbox.projects.irt.common import create_irt_data


class BmgenNormAndWordcountDicts(binary_task.LastBinaryTaskRelease, sdk2.Task):
    """
    Prepare "norm_dict" and "wordcount_dict"
    """

    class Parameters(sdk2.Parameters):
        ext_params = binary_task.binary_release_parameters(stable=True)

    def on_execute(self):
        import irt.bmgen.norm_and_wordcount_dicts as norm_and_wordcount
        import irt.sandbox as irt_sb

        sandbox_oauth_token=sdk2.Vault.data("sandbox_oauth_token")
        sb_client = irt_sb.Sandbox(sandbox_oauth_token)
        if (not sb_client.new_bmgen_resource_needed("norm_dict")) or (not sb_client.new_bmgen_resource_needed("wordcount_dict")):
            return
        if sb_client.not_released_bmgen_resources(("freq_wordforms",)) is None:
            return

        res_norm_info, res_wordcount_info = norm_and_wordcount.get_full_norm_info(sandbox_oauth_token)

        # Формируем ресурс для финального словаря нормализации
        norm_dict = create_irt_data(
            self,
            "norm_dict",
            "Словарь нормализации словофоворм Bannerland-а",
            ["rt-research/broadmatching/work/Norm/norm_dict"],
            ttl=30,
            check_task_mode=True,
        )

        with open(norm_dict.filenames[0], "w") as f:
            for winfo in res_norm_info:
                f.write("{}\t{}\n".format(winfo["token"], winfo["lemma_str"]))

        # Формируем ресурс для счетчика лемм
        wordcount_dict = create_irt_data(
            self,
            "wordcount_dict",
            "Счетчик лемм (словофоворм Bannerland-а)",
            ["rt-research/broadmatching/work/Norm/wordcount_dict"],
            ttl=30,
            check_task_mode=True,
        )

        with open(wordcount_dict.filenames[0], "w") as f:
            for lemma in sorted(res_wordcount_info.keys()):
                f.write("{}\t{}\n".format(lemma, res_wordcount_info[lemma]))
