# -*- coding: utf-8 -*-

import os

from sandbox import sdk2
from sandbox.common.types import client as client_types
from sandbox.projects.common import binary_task
from sandbox.projects.irt.common import create_irt_data

# Sandbox_ID замороженного ресурса с автоматически исправленными опечатками
REASK_FILE_ID = 1602083354


class BmgenSynonyms(binary_task.LastBinaryTaskRelease, sdk2.Task):
    """
    Generate synonyms for Bannerland
    """
    class Requirements(sdk2.Requirements):
        client_tags = client_types.Tag.SSD

    class Parameters(sdk2.Parameters):
        ext_params = binary_task.binary_release_parameters(stable=True)

    def on_execute(self):
        import irt.iron.options as iron_opts
        from irt.bmgen.synonyms import get_lang_synonyms_clusters
        from irt.sandbox import Sandbox
        from irt.utils import TemporaryDirectory

        sb_client = Sandbox(sdk2.Vault.data("sandbox_oauth_token"))
        if not sb_client.new_bmgen_resource_needed("synonyms"):
            return
        input_resources = sb_client.not_released_bmgen_resources(("norm_dict", "wordcount_dict"))
        if input_resources is None:
            return

        work_norm_path = iron_opts.get("work_norm_path")
        with TemporaryDirectory() as tmp_dir:

            reask_file = os.path.join(tmp_dir, sb_client.download(REASK_FILE_ID, tmp_dir)[0])

            src_path = sb_client.download(input_resources["norm_dict"]["id"], tmp_dir)
            norm_dict_path = os.path.join(tmp_dir, src_path[0], work_norm_path, "norm_dict")

            src_path = sb_client.download(input_resources["wordcount_dict"]["id"], tmp_dir)
            wordcount_dict_path = os.path.join(tmp_dir, src_path[0], work_norm_path, "wordcount_dict")

            syn_res = get_lang_synonyms_clusters(norm_dict_path, wordcount_dict_path, reask_file)
            sorted_langs = sorted(syn_res.keys())

            syn_data = create_irt_data(
                self,
                "synonyms",
                "Синонимы (русские и турецкие)",
                [os.path.join(work_norm_path, "syn_cells_{}".format(lang)) for lang in sorted_langs],
                ttl=30,
                check_task_mode=True,
            )

            for i in range(len(sorted_langs)):
                with open(syn_data.filenames[i], "wb") as f:
                    f.write(syn_res[sorted_langs[i]])
