from sandbox import sdk2


class MultikCaesarPackage(sdk2.Resource):
    releasable = True
    releasers = ["MULTIK"]

    version = sdk2.parameters.Integer("Version of package", required=True)

    revision = sdk2.parameters.Integer("Revision of code that was used to create graph", required=True)
    major = sdk2.parameters.Integer("Major version of code that was used to create graph (release branch)", required=False)
    minor = sdk2.parameters.Integer("Minor version of code that was used to create graph (release tag)", required=False)

    packaging = sdk2.parameters.String("Packaging type: None for directory, `tar`, `tar.gz`", required=True)


class MultikCaesarPackageV1(MultikCaesarPackage):
    pass


class MultikCaesarPackageV1Experiment(MultikCaesarPackageV1):
    pass
