from sandbox import sdk2

from sandbox.projects.resource_types import iss_releasers
from sandbox.projects.porto.common.resource_types import PORTO_LAYER


class IssResource(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String


class IssConfigResource(IssResource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = iss_releasers


class SKYMAP_JAR(IssResource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = iss_releasers


class CACHER_APPLICATION_CONF_TEMPLATE(IssResource):
    pass


class CACHER_JOLOKIA_POLICY(IssResource):
    pass


class CACHER_JOLOKIA_PROPERTIES(IssResource):
    pass


class CACHER_LOGBACK_XML(IssResource):
    pass


class CACHER_LOOP_CONF(IssResource):
    pass


class CACHER_STATUS_SCRIPT_TEMPLATE(IssResource):
    pass


class CACHER_RCCA_TRUSTED_PEM(IssResource):
    pass


class META_CAPI_APPLICATION_CONF(IssResource):
    pass
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = iss_releasers


class META_CAPI_JAR(IssResource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = iss_releasers


class ADM_CACHER_TAR(IssResource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = iss_releasers


class ADM_CASSANDRA_TAR(IssResource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = iss_releasers


class ISS_JDK_CERT(IssResource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = iss_releasers


class YP_EXPORT_SERVICE_JAR(IssResource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = iss_releasers


class YP_PDNS_BACKEND_JAR(IssResource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = iss_releasers


class YP_HFSM_SERVICE_JAR(IssResource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = iss_releasers


class QLOUD_HFSM_SERVICE_JAR(IssResource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = iss_releasers


class YP_CAUTH_EXPORT_SERVICE_JAR(IssResource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = iss_releasers


class YP_JDK_MUX_SCRIPT(IssResource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = iss_releasers


class YP_CREATE_TMPFS_SCRIPT(IssResource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = iss_releasers


class YP_OOM_KILLER_SCRIPT(IssResource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = iss_releasers


class YP_YASM_STW_UNISTAT_SCRIPT(IssResource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = iss_releasers


class QEMU_IMAGE_ISS_LOCAL(PORTO_LAYER):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = iss_releasers


class QEMU_IMAGE_ISS_TEAMCITY(PORTO_LAYER):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = iss_releasers


class LXC_IMAGE_ISS_LOCAL(IssResource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = iss_releasers


class QLOUD_MANAGER_JAR(IssResource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = iss_releasers
