# coding: utf-8
from sandbox.projects.common.iss.BuildFromArtifactoryTask import BuildFromArtifactoryTask, create_version_parameter
import sandbox.projects.iss

ARTIFACT_DIR = 'http://artifactory.yandex.net/artifactory/qe/ru/yandex/yp/hfsm/qloud-hfsm-service/'


class BuildQloudHFSMService(BuildFromArtifactoryTask):
    type = 'BUILD_QLOUD_HFSM_SERVICE'

    input_parameters = [
        create_version_parameter(ARTIFACT_DIR, 'QLOUD HFSM service artifact version')
    ]

    def _resource_path(self):
        return "qloud-hfsm-service.jar"

    def _artifact_dir(self):
        return ARTIFACT_DIR

    def _artifact_basename_template(self):
        return "qloud-hfsm-service-{version}.jar"

    def _resource_type(self):
        return sandbox.projects.iss.QLOUD_HFSM_SERVICE_JAR

    def _resource_id_context_key(self):
        return 'qloud_hfsm_service_jar_id'


__Task__ = BuildQloudHFSMService
