# coding: utf-8
from sandbox.projects.common.iss.BuildFromArtifactoryTask import BuildFromArtifactoryTask, create_version_parameter
import sandbox.projects.iss

ARTIFACT_DIR = 'http://artifactory.yandex.net/artifactory/qe/ru/yandex/qe/qloud/qloud-standalone/'


class BuildQloudManager(BuildFromArtifactoryTask):
    type = 'BUILD_QLOUD_MANAGER'

    input_parameters = [
        create_version_parameter(ARTIFACT_DIR, 'QLOUD_MANAGER service artifact version')
    ]

    def _resource_path(self):
        return "qloud-standalone-runnable.jar"

    def _artifact_dir(self):
        return ARTIFACT_DIR

    def _artifact_basename_template(self):
        return "qloud-standalone-{version}-runnable.jar"

    def _resource_type(self):
        return sandbox.projects.iss.QLOUD_MANAGER_JAR

    def _resource_id_context_key(self):
        return 'qloud_manager_jar_id'


__Task__ = BuildQloudManager
