# coding: utf-8
from sandbox.projects.common.iss.BuildFromArtifactoryTask import BuildFromArtifactoryTask, create_version_parameter
import sandbox.projects.iss

ARTIFACT_DIR = 'http://artifactory.yandex.net/artifactory/qe/ru/yandex/yp/hfsm/yp-hfsm-service/'


class BuildYpHFSMService(BuildFromArtifactoryTask):
    type = 'BUILD_YP_HFSM_SERVICE'

    input_parameters = [
        create_version_parameter(ARTIFACT_DIR, 'YP HFSM service artifact version')
    ]

    def _resource_path(self):
        return "yp-hfsm-service.jar"

    def _artifact_dir(self):
        return ARTIFACT_DIR

    def _artifact_basename_template(self):
        return "yp-hfsm-service-{version}.jar"

    def _resource_type(self):
        return sandbox.projects.iss.YP_HFSM_SERVICE_JAR

    def _resource_id_context_key(self):
        return 'yp_hfsm_service_jar_id'


__Task__ = BuildYpHFSMService
