# coding: utf-8
from sandbox.projects.common.iss.BuildFromArtifactoryTask import BuildFromArtifactoryTask, create_version_parameter
import sandbox.projects.iss

ARTIFACT_DIR = 'http://artifactory.yandex.net/artifactory/qe/ru/yandex/yp/pdns/yp-pdns-backend/'


class BuildYpPDNSBackend(BuildFromArtifactoryTask):
    type = 'BUILD_YP_PDNS_BACKEND'

    input_parameters = [
        create_version_parameter(ARTIFACT_DIR, 'YP PowerDNS backend artifact version')
    ]

    def _resource_path(self):
        return "yp-pdns-backend.jar"

    def _artifact_dir(self):
        return ARTIFACT_DIR

    def _artifact_basename_template(self):
        return "yp-pdns-backend-{version}.jar"

    def _resource_type(self):
        return sandbox.projects.iss.YP_PDNS_BACKEND_JAR

    def _resource_id_context_key(self):
        return 'yp_pdns_backend_jar_id'


__Task__ = BuildYpPDNSBackend
