# coding: utf-8
from sandbox.projects.common.iss.BuildFromArtifactoryTask import BuildFromArtifactoryTask, create_version_parameter
import sandbox.projects.iss

ARTIFACT_DIR = "http://artifactory.yandex.net/artifactory/qe/ru/yandex/qe/metacapi/metacapi-standalone/"


class ImportMetaCapiJar(BuildFromArtifactoryTask):
    """
        Download Meta-capi runnable .jar from QE artifactory and make Sandbox resource for continuous integration with Nanny
    """
    type = "IMPORT_META_CAPI_JAR"

    input_parameters = [
        create_version_parameter(ARTIFACT_DIR, "Meta-capi jar version")
    ]

    def _get_resource_ttl(self):
        return 365

    def _resource_path(self):
        return "metacapi-standalone-runnable.jar"

    def _artifact_dir(self):
        return ARTIFACT_DIR

    def _artifact_basename_template(self):
        return "metacapi-standalone-{version}-runnable.jar"

    def _resource_type(self):
        return sandbox.projects.iss.META_CAPI_JAR

    def _resource_id_context_key(self):
        return "meta_capi_jar"


__Task__ = ImportMetaCapiJar
