# coding: utf-8
from sandbox.projects.common.iss.BuildFromArtifactoryTask import BuildFromArtifactoryTask, create_version_parameter
import sandbox.projects.iss

ARTIFACT_DIR = "http://artifactory.yandex.net/artifactory/qe/ru/yandex/schedulers/skymap/skymap-uber-jar/"


class ImportSkyMapJar(BuildFromArtifactoryTask):
    """
        Download SkyMap uber .jar from QE artifactory and make Sandbox resource for continuous integration with Nanny
    """
    type = "IMPORT_SKYMAP_JAR"

    input_parameters = [
        create_version_parameter(ARTIFACT_DIR, "SkyMap uber jar version")
    ]

    def _get_resource_ttl(self):
        return 365

    def _resource_path(self):
        return "skymap-uber-jar.jar"

    def _artifact_dir(self):
        return ARTIFACT_DIR

    def _artifact_basename_template(self):
        return "skymap-uber-jar-{version}.jar"

    def _resource_type(self):
        return sandbox.projects.iss.SKYMAP_JAR

    def _resource_id_context_key(self):
        return "sky_map_jar_id"


__Task__ = ImportSkyMapJar
