import datetime

from sandbox.projects.runtime_models.BuildBegemotModelsPackageBase import BuildBegemotModelsPackageBase, get_build_models_package_parameters, StorageSources


class BuildGoodsModels(BuildBegemotModelsPackageBase):
    class Parameters(BuildBegemotModelsPackageBase.Parameters):
        _bmp = get_build_models_package_parameters(
            rules_to_deploy_default=[],
            bg_shard_default='GoodsModels',
            pack_to_tar_default=True,
        )

    @property
    def rule2models(self):
        return {
            'GoodsModels': {
                'MarketOptimizedModel': [
                    {
                        'source': StorageSources.YT,
                        'model_name': '',
                        'resource_type': 'YT_RESOURCE',
                        'update_period': datetime.timedelta(hours=1),
                        'resource_proxy_url': 'arnold.yt.yandex.net',
                        'owner': 'SEARCH-RELEASERS',
                        'yt_token_secret_name': 'yt_token_for_testenv',
                        'components': [
                            {
                                'path': '//home/izolenta/real_time_training/market/bundles',
                                'version_type': datetime.datetime,
                                'format': '%Y-%m-%dT%H:%M:%S',
                                'attributes': ['ModelNames', 'ModelStates'],
                                'children': [
                                    {'path': 'market_optimized_model.dssm'},
                                ],
                            },
                        ],
                    },
                ],
            },
        }
