# -*- coding: utf-8 -*-

import logging
from sandbox import common
import time
from datetime import datetime


def detect_shards_count(task, state, yt_wrapper):
    tiercfg_file = str(task.path('TierScheme.pb.txt'))
    yt_client = yt_wrapper.YtClient(proxy="arnold", token=yt_wrapper.config["token"])
    tiercfg_stream = yt_client.read_file("//home/jupiter/selectionrank/" + state + "/TierScheme.pb.txt")
    with open(tiercfg_file, 'w') as out:
        out.write(tiercfg_stream.read())

    judtier_num_shards = None
    with open(tiercfg_file, 'r') as tiercfg:
        nesting_level = 0
        cur_tier_name = None
        cur_num_shards = None
        for line in tiercfg:
            line = line.strip(' \r\n')
            if '{' in line:
                if line.find('{') != len(line) - 1:
                    raise common.errors.TaskError("Failed to parse TierScheme.pb.txt: unexpected '{'")
                nesting_level += 1
            if '}' in line:
                if line != '}':
                    raise common.errors.TaskError("Failed to parse TierScheme.pb.txt: unexpected '}'")
                nesting_level -= 1
                if nesting_level < 0:
                    raise common.errors.TaskError("Failed to parse TierScheme.pb.txt: too much '}'")
                if nesting_level == 0:
                    if cur_tier_name == 'JudTier':
                        judtier_num_shards = cur_num_shards
                    cur_tier_name = None
                    cur_num_shards = None
            if line.startswith('TierName: "') and line.endswith('"'):
                cur_tier_name = line[len('TierName: "'):-1]
            if line.startswith('NumShards: '):
                cur_num_shards = int(line[len('NumShards: '):])
        if nesting_level:
            raise common.errors.TaskError("Failed to parse TierScheme.pb.txt: too much '{'")
    if not judtier_num_shards:
        raise common.errors.TaskError("JudTier config not found in TierScheme.pb.txt")
    logging.info("JudTier shards count: {}".format(judtier_num_shards))
    return judtier_num_shards


def state_to_timestamp(state):
    return int(time.mktime(
        datetime.strptime(state, '%Y%m%d-%H%M%S').timetuple()
    ))
