# coding: utf-8

import json
import os
import os.path
import time

import sandbox.common.types.client as ctc
from sandbox.sandboxsdk.errors import SandboxTaskFailureError
import sandbox.sandboxsdk.svn as sdk_svn

from sandbox.projects.common.juggler.check_bundles import BaseBuildJugglerChecksBundleTask, ForceResourceCreationParameter


class BuildJugglerChecksBundleFromPsSnake(BaseBuildJugglerChecksBundleTask):
    """
    Create checks bundle from ps-snake classes hierarchy
    """

    type = 'BUILD_JUGGLER_CHECKS_BUNDLE_FROM_PS_SNAKE'
    _BUNDLE_URL = "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/juggler/bundles/ps_search2"
    input_parameters = [ForceResourceCreationParameter]
    client_tags = ctc.Tag.Group.LINUX

    def on_execute(self):
        local_root = self.path('root')
        sdk_svn.Svn.checkout(url=self._BUNDLE_URL, path=local_root)

        manifest_path = os.path.join(local_root, "MANIFEST.json")
        if not os.path.exists(manifest_path):
            raise SandboxTaskFailureError('MANIFEST.json file is not found')

        with open(manifest_path) as stream:
            manifest = json.load(stream)

        manifest["timestamp"] = int(time.time())
        manifest["build_number"] = self.id

        for check in manifest["checks"]:
            file_path = os.path.join(local_root, check["check_script"])
            check["check_hash"] = self._get_file_hash(file_path)

        files_list = [
            (os.path.join(local_root, file_name), file_name)
            for file_name in os.listdir(local_root)
            # ignore private files like .svn and manifest
            if not file_name.startswith(".") and file_name not in ("MANIFEST.json", "ya.make")
        ]

        self._make_bundle_resource(manifest, files_list, resource_type="JUGGLER_CHECKS_BUNDLE",
                                   s3_user={"vault_owner": "JUGGLER", "vault_name": "juggler-s3-bundles-bucket-auth"},
                                   s3_endpoint="s3.mds.yandex.net")
