# coding: utf-8

import sandbox.common.types.client as ctc

from sandbox.projects.common.juggler import base


class RepoNameParameter(base.RepoNameParameter):
    default_value = 'search'


class BuildJugglerConfigSearchDeb(base.BaseBuildJugglerDebTask):
    """
    Build config-juggler-search deb package and upload it to dist.yandex.ru.
    """

    type = 'BUILD_JUGGLER_CONFIG_SEARCH_DEB'

    execution_space = 1000

    input_parameters = base.BaseBuildJugglerTask.input_parameters + [
        RepoNameParameter,
        base.VersionPostfixParameter
    ]

    client_tags = ctc.Tag.LINUX_PRECISE

    REPO_NAME = 'config-juggler-search'

    def on_release(self, additional_parameters):
        self._create_conductor_ticket(additional_parameters['release_status'])
