# coding: utf-8

import sandbox.common.types.client as ctc

from sandbox.projects.common.juggler import base


class RepoNameParameter(base.RepoNameParameter):
    default_value = 'common'


class BuildJugglerMonrunDeb(base.BaseBuildJugglerDebTask):
    """
    Build monrun deb package and upload it to dist.yandex.ru.
    """

    type = 'BUILD_JUGGLER_MONRUN_DEB'

    execution_space = 1000

    input_parameters = base.BaseBuildJugglerTask.input_parameters + [
        RepoNameParameter,
        base.VersionPostfixParameter
    ]

    client_tags = ctc.Tag.LINUX_PRECISE

    REPO_NAME = 'monrun'

    def on_release(self, additional_parameters):
        self._create_conductor_ticket(additional_parameters['release_status'])


__Task__ = BuildJugglerMonrunDeb
