# coding: utf-8
from __future__ import absolute_import

from sandbox import sdk2

# for backward compatibility, do not use it, use sdk2.Resource instead
AbstractResource = sdk2.resource.AbstractResource

RELEASERS = [
    'dldmitry',
    'squirrel',
    'efmv',
    'rocco66',
    'alovtsyus',
    'isivakov',
    'vorkdenis',
    'msedlyarskiy',
    'iperfilyev',
    'robot-juggling',
    'nanny-robot',
]


class JUGGLER_CLIENT_BINARY(AbstractResource):
    """
        Juggler client binary
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = RELEASERS


class JUGGLER_WHEEL(AbstractResource):
    """
        Juggler's wheel for python
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = RELEASERS


class JUGGLER_DEB_PACKAGE(AbstractResource):
    """
        Juggler deb packages meta file
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = False
    releasers = RELEASERS


class JUGGLER_ANSIBLE(AbstractResource):
    """
        Juggler ansible project
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = RELEASERS


class JUGGLER_PONGER_BINARIES(sdk2.Resource):
    """
        Juggler ponger binaries archive
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = RELEASERS


class JUGGLER_CONFIG(AbstractResource):
    """
        Base resource type
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = RELEASERS


class JUGGLER_DASHBOARD(JUGGLER_CONFIG):
    """
        JUGGLER_DASHBOARD
    """
    releasers = ['JUGGLER', 'INFRACLOUDUI']
    any_arch = False


class JNS_WEBAPP(sdk2.Resource):
    """JNS UI resource"""
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True
    releasers = ['JUGGLER', 'INFRACLOUDUI']


class JNS_BINARY(sdk2.Resource):
    """
    Binary for launching jns api
    """
    releasable = True
    releasers = ['JUGGLER', 'INFRACLOUDUI']
    auto_backup = True


class JNS_SERVER(sdk2.Resource):
    """
        JNS server archive
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = RELEASERS


class JUGGLER_SERVER_DOCKER(sdk2.Resource):
    """
        Juggler server docker image
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = RELEASERS


class JUGGLER_BATCHER_DOCKER(sdk2.Resource):
    """
        Juggler batcher docker image
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = RELEASERS


class JUGGLER_AGGRDB_DOCKER(sdk2.Resource):
    """
        Juggler aggregation-db docker image
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = RELEASERS


class JUGGLER_PONGER_DOCKER(sdk2.Resource):
    """
        Juggler ponger docker image
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = RELEASERS


class JUGGLER_CHECKS_BUNDLE(AbstractResource):
    "Bundle of check scripts and their metadata"
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = RELEASERS


class JCTL_LINUX(sdk2.Resource):
    "jctl binary for Linux"
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = RELEASERS
    arcadia_build_path = 'juggler/jctl/bin'


class JCTL_DARWIN(sdk2.Resource):
    "jctl binary for MacOS"
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = RELEASERS
    arcadia_build_path = 'juggler/jctl/bin'
