def _get_html_page(entry):
    return """<html>
<head>
    <link type="text/css" href="//yandex.st/bootstrap/3.3.6/css/bootstrap.min.css">
</head>
<body>
    <div class="containter">
        <div class="col-md-12">
        {}
        </div>
    </div>
</body>
</html>
""".format(entry)


def _get_table_row(*values):
    row_columns = ["<td>{}</td>".format(value) for value in values]
    return "<tr>{}</tr>".format("".join(row_columns))


def _get_table_head(*column_names):
    return _get_table_row(*["<h4 align='center'>{}</h4>".format(name) for name in column_names])


def _get_table(table_head, table_body):
    if table_head:
        return "<table><thead>{}</thead><tbody>{}</tbody></table>".format(table_head, table_body)
    else:
        return "<table><tbody>{}</tbody></table>".format(table_body)


def _get_href(link, text):
    return "<a href='{}'>{}</a>".format(link, text)


def get_file_list_result(result):
    table_head = _get_table_head("Jupiter", "Mercury-SaaS", "Callisto-Mercury")

    table_rows = []
    for filename, result_list in sorted(result.iteritems()):
        table_rows.append(_get_table_row(filename, *result_list))

    table = _get_table(table_head, "\n".join(table_rows))
    return _get_html_page(table)


def get_diff_result(file_list_diff, index_diff_links):
    entries = []
    if file_list_diff:
        table_head = _get_table_head(
            "Jupiter",
            "Mercury-SaaS (first)",
            "Callisto-Mercury (first)",
            "->",
            "Mercury-SaaS (second)",
            "Callisto-Mercury (second)")

        table_rows = []
        for filename, result_list in sorted(file_list_diff.iteritems()):
            diff_row = result_list[0] + ["->"] + result_list[1]
            table_rows.append(_get_table_row(filename, *diff_row))

        table = _get_table(table_head, "\n".join(table_rows))
        title = "<h3>File list diff</h3>"
        entries.append(title)
        entries.append(table)

    if index_diff_links:
        rows = []
        for name, link in index_diff_links:
            row = _get_table_row(name + ":", _get_href(link, "See diff changes"))
            rows.append(row)
        table = _get_table(None, "\n".join(rows))
        title = "<h3>Index entry diff</h3>"
        entries.append(title)
        entries.append(table)

    if entries:
        return _get_html_page("\n".join(entries))
    else:
        return _get_html_page("<pre>No diff</pre>")


def _get_lost_docs_table(result, first_name, second_name):
    table_head = _get_table_head(
        first_name,
        "<->",
        second_name)

    table_rows = []
    for shard_docs in result:
        row = []
        for shard_doc in shard_docs:  # always 2
            row.append(shard_doc or "Lost")
        row.insert(1, "<->")
        table_rows.append(_get_table_row(*row))

    return _get_table(table_head, "\n".join(table_rows))


def get_lost_docs_result(result, first_name, second_name):
    if result:
        table = _get_lost_docs_table(result, first_name, second_name)
        title = "<h3>Lost documents</h3>"
        return _get_html_page(title + table)
    else:
        return _get_html_page("<pre>All documents present</pre>")


def get_lost_docs_diff_result(result, first_name, second_name):
    entries = []
    if result["new"]:
        entries.append("<h3>New lost documents</h3>")
        entries.append(_get_lost_docs_table(result["new"], first_name, second_name))
    if result["missed"]:
        entries.append("<h3>Gone lost documents</h3>")
        entries.append(_get_lost_docs_table(result["missed"], first_name, second_name))
    if entries:
        return _get_html_page("\n".join(entries))


def get_brief_html(links):
    rows = []
    for name, link in links:
        row = _get_table_row(name + ":", _get_href(link, "See details"))
        rows.append(row)
    table = _get_table(None, "\n".join(rows))
    return _get_html_page(table)
