from sandbox import sdk2
from sandbox.common.types.task import ReleaseStatus


class JupiterCompareIndexTool(sdk2.Resource):
    """
    Compare tool (binary file)
    """
    auto_backup = True
    executable = True
    releasable = True
    release_subscribers = ["jupiter-tests"]


def get_last_released():
    return JupiterCompareIndexTool.find(
        attrs={"released": ReleaseStatus.STABLE},
    ).order(-sdk2.Resource.id).first()
