# -*- coding: utf-8 -*-

import logging
import time

from sandbox import sdk2


class JupiterEnrichReleaseAttributes(sdk2.Task):
    '''
    Add some attributes to released resources to make jupiter release cycle more convinient.
    '''
    class Requirements(sdk2.Task.Requirements):
        disk_space = 1024  # Mb

    class Parameters(sdk2.Task.Parameters):
        component_resources = sdk2.parameters.Dict("Component name Resources")
        with sdk2.parameters.String("Scheduling policy") as scheduling_policy:
            scheduling_policy.values.IMMEDIATE = "immediate"
            scheduling_policy.values.NEXT_RUN = "next_run"

    def on_execute(self):
        now = time.time()
        for res_id in self.Parameters.component_resources.values():
            logging.info("Setting attribute for resource #%s", res_id)
            resource = sdk2.Resource.find(type=None, id=res_id).first()
            resource.release_time = str(now)
            resource.scheduling_policy = self.Parameters.scheduling_policy
