# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.common.telegram import TelegramBot


class JupiterNotifyRelease(sdk2.Task):
    '''
    Add some attributes to released resources to make jupiter release cycle more convinient.
    '''
    class Requirements(sdk2.Task.Requirements):
        disk_space = 1024  # Mb

    class Parameters(sdk2.Task.Parameters):
        '''
        Task parameters:
            :param message: notification message
            :param list of notification chat ids:
            :param vault_telegram_token: Telegram token name in secure vault
        '''
        message = sdk2.parameters.String(
            label="Message",
            description="Notification message",
            required=True,
        )
        chats = sdk2.parameters.List(
            label="Chat ids",
            description="List of notification chat ids",
            required=True,
        )
        telegram_token_name = sdk2.parameters.String(
            label="Telegram token name",
            description="Name of sandbox vault item with telegram token allowing access to notification bot",
            required=True,
        )

    def on_execute(self):
        message = self.Parameters.message
        chats = self.Parameters.chats

        token = sdk2.Vault.data(self.Parameters.telegram_token_name)
        bot = TelegramBot(token)

        for chat in chats:
            bot.send_message(
                chat_id=chat,
                text=message
            )
