# -*- coding: utf-8 -*-

import logging
from contextlib import contextmanager
import os
import sys
from os.path import join as pj
import subprocess as sp

from sandbox import sdk2
from sandbox.projects.common.nanny import nanny


class ExtFilesResourceBase(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True


class JupiterAntispamRules(ExtFilesResourceBase):
    pass


class JupiterAntispamNastyFixes(ExtFilesResourceBase):
    pass


class JupiterAntispamRulesBundle(ExtFilesResourceBase):
    pass


class JupiterAntispamAttRulemap(ExtFilesResourceBase):
    pass


class JupiterAntispamExtraRulemap(ExtFilesResourceBase):
    pass


class JupiterAntispamMascotBundle(ExtFilesResourceBase):
    pass


class JupiterAntispamQueriesBundle(ExtFilesResourceBase):
    pass


class JupiterAntispamDomainAttributesBundle(ExtFilesResourceBase):
    pass


class JupiterAntispamPlayerConfigBundle(ExtFilesResourceBase):
    pass


class JupiterBaseSearchBundle(ExtFilesResourceBase):
    pass


class JupiterDssmModels(ExtFilesResourceBase):
    pass


class JupiterMiddleSearchBundle(ExtFilesResourceBase):
    pass


class JupiterSelectionRankBundle(ExtFilesResourceBase):
    pass


class JupiterPantherDssmBundle(ExtFilesResourceBase):
    pass


class JupiterNeuralNetworkOverDssmBundle(ExtFilesResourceBase):
    pass


class JupiterItdItpDocumentModelBundle(ExtFilesResourceBase):
    pass


class ItdItpStaticModelsFile(ExtFilesResourceBase):
    """ this is a type of Delivery input, to be repackaged as JupiterItdItpStaticModelsBundle """
    pass


class JupiterItdItpStaticModelsBundle(ExtFilesResourceBase):
    pass


class JupiterFakedatBundle(ExtFilesResourceBase):
    pass


class JupiterQueryrecBundle(ExtFilesResourceBase):
    pass


class JupiterFilterTrie(ExtFilesResourceBase):
    pass


class JupiterMergedGeminiRfl(ExtFilesResourceBase):
    pass


class JupiterPolyglotFiles(ExtFilesResourceBase):
    pass


class JupiterMirrorsTrie(ExtFilesResourceBase):
    pass


class JupiterCatalogFlt(ExtFilesResourceBase):
    pass


class JupiterLinkAggregatorData(ExtFilesResourceBase):
    pass


class JupiterHostfactorsCalcData(ExtFilesResourceBase):
    pass


class JupiterOwnerClonMain(ExtFilesResourceBase):
    pass


class JupiterSnippets(ExtFilesResourceBase):
    releasable = False


class JupiterYacatalogLinkTexts(ExtFilesResourceBase):
    pass


class JupiterMirrorsRes(ExtFilesResourceBase):
    pass


class JupiterAreasLst(ExtFilesResourceBase):
    pass


class YqlUdfAreasLst(ExtFilesResourceBase):
    pass


class YqlUdfPure(ExtFilesResourceBase):
    pass


class YqlUdfSeolnk(ExtFilesResourceBase):
    pass


class YqlPdfOcrPackage(ExtFilesResourceBase):
    pass


class YqlUdfDirectTextConfig(ExtFilesResourceBase):
    pass


class YqlUdfNumbers(ExtFilesResourceBase):
    pass


class YqlUdfOfferParser(ExtFilesResourceBase):
    pass


class YqlUdfProductsOnPagesRegexClassifier(ExtFilesResourceBase):
    pass


class YqlUnstructuredDataHosts(ExtFilesResourceBase):
    pass


class YqlUdf2ldList(ExtFilesResourceBase):
    pass


class YqlUdfFio(ExtFilesResourceBase):
    pass


class YqlUdfPhoneMarkers(ExtFilesResourceBase):
    pass


class YqlUdfDictDict(ExtFilesResourceBase):
    pass


class YqlUdfStopWordLst(ExtFilesResourceBase):
    pass


class YqlUdfPornoWeights(ExtFilesResourceBase):
    pass


class YqlUdfForcesInfo(ExtFilesResourceBase):
    pass


class YqlUdfPornofilter(ExtFilesResourceBase):
    pass


class YqlUdfShop(ExtFilesResourceBase):
    pass


class YqlUdfCommercialDict(ExtFilesResourceBase):
    pass


class YqlUdfPpbHosts(ExtFilesResourceBase):
    pass


class YqlUdfMorphFixList(ExtFilesResourceBase):
    pass


class YqlUdfDssmModels(ExtFilesResourceBase):
    pass


class YqlUdfQueryRec(ExtFilesResourceBase):
    pass


class YqlUdfSynData(ExtFilesResourceBase):
    pass


class YqlUdfNumeratorConfig(ExtFilesResourceBase):
    pass


class YqlUdfAntispamRules(ExtFilesResourceBase):
    pass


class YqlUdfStreetsTrie(ExtFilesResourceBase):
    pass


class YqlUdfVideoConfigs(ExtFilesResourceBase):
    pass


class YqlUdfGetowneraggregate(ExtFilesResourceBase):
    pass


class YqlUdfFnormDat(ExtFilesResourceBase):
    pass


class YqlUdfVideoTextFactors(ExtFilesResourceBase):
    pass


class YqlUdfUrlTransliterationData(ExtFilesResourceBase):
    pass


class JupiterNavsourceMarkers(ExtFilesResourceBase):
    pass


class JupiterPrsL2Formula(ExtFilesResourceBase):
    pass


class JupiterOptimizedRthubBundle(ExtFilesResourceBase):
    pass


class JupiterTriggerWords(ExtFilesResourceBase):
    pass


def partialCheckout(url, paths, dst):
    sdk2.svn.Arcadia.checkout(url, dst, depth='empty')
    rev = sdk2.svn.Arcadia.parse_url(url).revision

    logging.debug('============= Arcadia CHECKOUT =========================')
    logging.debug('got dirs to checkout:\n%s', '\n'.join(paths))

    for path in paths:
        logging.debug('======================================')
        logging.debug('Checkouting %s', path)
        fulldir = ''
        path_spl = path.split(os.sep)
        for directory in path_spl:
            fulldir = os.path.join(fulldir, directory)
            path_to_update = os.path.join(dst, fulldir)
            if not os.path.exists(path_to_update):
                if fulldir in paths:
                    sdk2.svn.Arcadia.update(path_to_update, revision=rev)
                else:
                    sdk2.svn.Arcadia.update(path_to_update, depth=None, set_depth='files', revision=rev)


@contextmanager
def pushd(newDir):
    previousDir = os.getcwd()
    os.chdir(newDir)
    try:
        yield
    finally:
        os.chdir(previousDir)


class JupiterReleaseExtFiles(sdk2.Task, nanny.ReleaseToNannyTask2):
    '''
    Скачивание всевозможных файликов по rsync, http и из svn для последующей загрузки в Юпитер.
    '''
    class Requirements(sdk2.Task.Requirements):
        disk_space = 60000  # Mb

    class Parameters(sdk2.Task.Parameters):
        bundles_to_build = sdk2.parameters.String(
            'Resources to build seperated by \';\'. By default download all resources')

        force_rebuild = sdk2.parameters.Bool('Force rebuild', default=False)
        full_paths_meta = sdk2.parameters.Bool('Use full paths in meta.json', default=False)
        create_tar_archive = sdk2.parameters.Bool('Create tar archive for result resource', default=False)

        sandbox_token_name = sdk2.parameters.String('Vault item name with sandbox token',
                                                    default='jupiter_sb_token')
        sandbox_token_owner = sdk2.parameters.String('Vault item with sandbox token owner',
                                                     default='JUPITER')
        set_ttl_inf = sdk2.parameters.Bool('Set ttl = \'inf\' for output resources', default=False)

    EXTFILES_SCRIPT = 'robot/jupiter/delivery/scripts/extfiles.py'
    SBCLIENT_SCRIPT = 'robot/jupiter/cm/scripts/sbclient.py'

    ARC_DEPENDENCIES = [
        'search/garden/sandboxsdk',
    ]

    SCRIPTS_TO_EXPORT = [
        EXTFILES_SCRIPT,
        SBCLIENT_SCRIPT
    ]

    @property
    def footer(self):
        return '<h2>Downloaded resource ids: {}</h2><br>{}'.format(
            self.Context.downloaded_resources, self.status)

    def on_execute(self):
        sandbox_token = sdk2.Vault.data(
            self.Parameters.sandbox_token_owner,
            self.Parameters.sandbox_token_name
        )
        arcadia = str(self.path('arcadia'))
        sdk2.Path.mkdir(sdk2.Path(arcadia))
        partialCheckout(sdk2.svn.Arcadia.trunk_url(), self.ARC_DEPENDENCIES, arcadia)

        for script in self.SCRIPTS_TO_EXPORT:
            sdk2.svn.Arcadia.export(
                pj(sdk2.svn.Arcadia.trunk_url(), script), pj(str(self.path(os.path.basename(script)))))

        extfiles_cmd = [
            sys.executable,
            pj(str(self.path()), os.path.basename(self.EXTFILES_SCRIPT)),
        ]

        if self.Parameters.bundles_to_build:
            extfiles_cmd += ['-b', self.Parameters.bundles_to_build]

        if self.Parameters.force_rebuild:
            extfiles_cmd += ['--force-rebuild']

        if self.Parameters.full_paths_meta:
            extfiles_cmd += ['--full-paths-meta']

        extfiles_env = os.environ.copy()
        extfiles_env["SB_TOKEN"] = sandbox_token

        extfiles_run = str(self.path('extfiles_run'))
        sdk2.Path.mkdir(sdk2.Path(extfiles_run))
        with pushd(extfiles_run):
            with sdk2.helpers.ProcessLog(self, logger='extfiles') as pl:
                logging.info('Running %s', ' '.join(extfiles_cmd))
                sp.check_call(extfiles_cmd, env=extfiles_env, stdout=pl.stdout, stderr=sp.STDOUT)

        self.Context.downloaded_resources = {}
        for directory in os.listdir(extfiles_run):
            extfiles_directory = pj(extfiles_run, directory)
            resource_units = os.listdir(extfiles_directory)
            if resource_units:
                resource_class = sdk2.Resource[directory]
                if self.Parameters.create_tar_archive:
                    archive_file = directory + ".tar"
                    work_dir = os.getcwd()
                    with pushd(extfiles_directory):
                        sp.check_call(["tar", "cvf", pj(work_dir, archive_file)] + resource_units)
                    full_path = pj(os.getcwd(), archive_file)
                else:
                    full_path = extfiles_directory

                resource = resource_class(
                    self,
                    'This resource created by {} for delivery'.format(self.type),
                    full_path
                )
                if self.Parameters.set_ttl_inf:
                    resource.ttl = 'inf'
                resource_data = sdk2.ResourceData(resource)
                resource_data.ready()

                downloaded_resources = self.Context.downloaded_resources
                downloaded_resources[directory] = resource.id
                self.Context.downloaded_resources = downloaded_resources
            else:
                logging.info("Bundle %s wasn't created because nothing was updated inside it.", directory)

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
