from sandbox import sdk2
from sandbox.projects.common import binary_task

import os


class JupiterCommitIntegrationData(binary_task.LastBinaryTaskRelease, sdk2.Task):
    """
    Task updates id of resource in robot/jupiter/test/common/integration_yt_data.make.
    """

    class Requirements(sdk2.Task.Requirements):
        disk_space = 1024  # Mb

    class Parameters(binary_task.LastBinaryReleaseParameters):
        _lbrp = binary_task.binary_release_parameters(stable=True)

        resource_id = sdk2.parameters.String("Id of new resource", required=True)
        sample_type = sdk2.parameters.String("Type of sample", default="integration")
        ssh_key_name = sdk2.parameters.String(
            "Name of the sandbox vault record storing ssh key", default="jupiter_sb_ssh_key")
        ssh_key_owner = sdk2.parameters.String("Owner of the sandbox vault record storing ssh key", default="JUPITER")
        ssh_key_user = sdk2.parameters.String("User of the ssh key", default="robot-jupiter-sb")

        yt_data_make_file_location = sdk2.parameters.String(
            "Arcadia url to make file with sandbox resource id",
            default="svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/robot/jupiter/test/common")
        yt_data_make_file_name = sdk2.parameters.String(
            "Name of the file with sandbox resource id", default="integration_yt_data.make")

    def on_execute(self):
        from robot.jupiter.library.python.sample import autocommit

        review_id = None
        with sdk2.ssh.Key(self, key_owner=self.Parameters.ssh_key_owner, key_name=self.Parameters.ssh_key_name):
            sdk2.svn.Arcadia.checkout(
                url=self.Parameters.yt_data_make_file_location,
                path=os.curdir,
                depth='immediates'
            )

            file_path = self.Parameters.yt_data_make_file_name
            with open(file_path, 'w') as fd:
                fd.write("DATA(sbr://{})\nDISABLE_DATA_VALIDATION()\n".format(self.Parameters.resource_id))

            revprops = [
                "arcanum:review-groups=jupiter",
                "arcanum:review-publish=yes",
                "arcanum:review=new",
            ]
            review_id = autocommit.create_review(
                path=file_path,
                message="Update sample for {}".format(self.Parameters.sample_type),
                user=self.Parameters.ssh_key_user,
                with_revprop=revprops,
            )
        self.set_info("Created review with id {}".format(review_id))
